package cn.smarthse.modules.health.entity.work.harmfactor;

import cn.smarthse.modules.health.entity.base.occriskfactor.OccupationalRiskFactors;
import cn.smarthse.modules.health.vo.work.harmfactor.HarmSourceJsonVo;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Table(name = "harmfactor_work_source")
public @Data class HarmfactorWorkSource implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 岗位危害因素id(work_harmfactor.id)
     */
    @Column(name = "work_harmfactor_id")
    private Long workHarmfactorId;
	@Transient
    private Long workId;
    @Column(name = "harm_id")
    private Long harmId;

	@Transient
    private OccupationalRiskFactors harm;
    //用于接受从危害因素检测过来的数据（格式：harm_id!#!hazardSource~@~harm_id!#!hazardSource）
    @Transient
    private String harmNameId;
    /**
     * 危害来源
     */
    @Column(name = "hazard_source")
    private String hazardSource;

    /**
     * 检测( HC_CheckPlan 主键)   获取检测编号
     */
    @Column(name = "check_plan_id")
    private Long checkPlanId;

    /**
     * 检测时间
     */
    @Column(name = "check_date")
    private Date checkDate;

    /**
     * 是否为历史数据
     */
    @Column(name = "is_his")
    private Boolean isHis;

    /**
     * 是否完成
     */
    @Column(name = "is_finish")
    private Boolean isFinish;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效, -1历史）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 检测报告危害因素关联 特有， 存放harm与 source 的关系
     */
    @Transient
    private List<HarmSourceJsonVo> harmSourceJsonVoList;
    /**
     * 危害因素管理 编辑页面 删除信息
     */
    @Transient
    private String deleteMetaInfo;
}