package cn.smarthse.modules.health.entity.work.harmfactor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import cn.smarthse.modules.health.entity.base.workinfo.WorkRoleInfo;
import lombok.Data;

@Table(name = "harmfactor_work")
public @Data class HarmfactorWork implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 岗位ID
     */
    @Column(name = "work_id")
    private Long workId;
    @Transient
    private WorkRoleInfo work;
    /**
     * 接触方式1:定点；2：巡检
     */
    @Column(name = "contact_type")
    private Byte contactType;
    @Transient
    private List<HarmfactorWorkSource> harmfactorWorkSourceList;

/**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建人对应的部门
     */
    @Column(name = "org_id")
    private Long orgId;
    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;
    @Transient
    private String workName;
    
    /**
	 * 岗位总人数
	 */
    @Transient
	private Integer workRoleUserCount;
	
	
	/**
	 * 危害因素名称
	 */
    @Transient
	private String harmFactorNames;
	
	/**
	 * 危害因素来源
	 */
    @Transient
	private String harmFactorSource;
    private static final long serialVersionUID = 1L;
}