package cn.smarthse.modules.health.entity.work.harmfactor;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "harmfactor_hccheckplanunderway")
public class HarmfactorHccheckplanunderway implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 检测报告ID
     */
    @Column(name = "hccplan_id")
    private Long hccplanId;

    /**
     * 检测报告名称(冗余)
     */
    @Column(name = "hccplan_name")
    private String hccplanName;

    /**
     * 检测开始时间（冗余字段）
     */
    @Column(name = "hazard_start_date")
    private Date hazardStartDate;

    /**
     * 检测结束时间（冗余字段）
     */
    @Column(name = "hazard_end_date")
    private Date hazardEndDate;

    /**
     * 检测类型 （冗余-需转换为文本）
     */
    @Column(name = "hazard_type")
    private String hazardType;

    /**
     * 是否完成
     */
    @Column(name = "is_finish")
    private Boolean isFinish;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效, -1历史）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取检测报告ID
     *
     * @return hccplan_id - 检测报告ID
     */
    public Long getHccplanId() {
        return hccplanId;
    }

    /**
     * 设置检测报告ID
     *
     * @param hccplanId 检测报告ID
     */
    public void setHccplanId(Long hccplanId) {
        this.hccplanId = hccplanId;
    }

    /**
     * 获取检测报告名称(冗余)
     *
     * @return hccplan_name - 检测报告名称(冗余)
     */
    public String getHccplanName() {
        return hccplanName;
    }

    /**
     * 设置检测报告名称(冗余)
     *
     * @param hccplanName 检测报告名称(冗余)
     */
    public void setHccplanName(String hccplanName) {
        this.hccplanName = hccplanName == null ? null : hccplanName.trim();
    }

    /**
     * 获取检测开始时间（冗余字段）
     *
     * @return hazard_start_date - 检测开始时间（冗余字段）
     */
    public Date getHazardStartDate() {
        return hazardStartDate;
    }

    /**
     * 设置检测开始时间（冗余字段）
     *
     * @param hazardStartDate 检测开始时间（冗余字段）
     */
    public void setHazardStartDate(Date hazardStartDate) {
        this.hazardStartDate = hazardStartDate;
    }

    /**
     * 获取检测结束时间（冗余字段）
     *
     * @return hazard_end_date - 检测结束时间（冗余字段）
     */
    public Date getHazardEndDate() {
        return hazardEndDate;
    }

    /**
     * 设置检测结束时间（冗余字段）
     *
     * @param hazardEndDate 检测结束时间（冗余字段）
     */
    public void setHazardEndDate(Date hazardEndDate) {
        this.hazardEndDate = hazardEndDate;
    }

    /**
     * 获取检测类型 （冗余-需转换为文本）
     *
     * @return hazard_type - 检测类型 （冗余-需转换为文本）
     */
    public String getHazardType() {
        return hazardType;
    }

    /**
     * 设置检测类型 （冗余-需转换为文本）
     *
     * @param hazardType 检测类型 （冗余-需转换为文本）
     */
    public void setHazardType(String hazardType) {
        this.hazardType = hazardType == null ? null : hazardType.trim();
    }

    /**
     * 获取是否完成
     *
     * @return is_finish - 是否完成
     */
    public Boolean getIsFinish() {
        return isFinish;
    }

    /**
     * 设置是否完成
     *
     * @param isFinish 是否完成
     */
    public void setIsFinish(Boolean isFinish) {
        this.isFinish = isFinish;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效, -1历史）
     *
     * @return is_valid - 是否有效（0-无效，1-有效, -1历史）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效, -1历史）
     *
     * @param isValid 是否有效（0-无效，1-有效, -1历史）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}