package cn.smarthse.modules.health.entity.work.harmfactor;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * @author zhoulj(周利军) [1217102780@qq.com]
 * @Title: HarmfactorAreaSource
 * @Project: ${MODEL_NAME}
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 31
 * @since 2020/3/12-16:31
 */
@Data
@Table(name = "harmfactor_area_source")
public class HarmfactorAreaSource implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 岗位危害因素id(work_harmfactor.id)
     */
    private Long areaId;

    private Long harmId;

    /**
     * 危害来源
     */
    private String hazardSource;

    /**
     * 检测( HC_CheckPlan 主键)   获取检测编号
     */
    private Long checkPlanId;

    /**
     * 检测时间
     */
    private Date checkDate;

    /**
     * 是否为历史数据
     */
    private Boolean isHis;

    /**
     * 创建时间
     */
    private Date createDate;

    /**
     * 创建人
     */
    private Long createBy;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    private Boolean isValid;

    /**
     * 是否完成
     */
    private Boolean isFinish;

    private static final long serialVersionUID = 1L;
}