package cn.smarthse.modules.health.entity.work.harmfactor;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "harmfactor_area")
public @Data class HarmfactorArea implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 区域ID
     */
    @Column(name = "area_id")
    private Long areaId;

    /**
     * 接触的危害因素
     */
    @Column(name = "harm_id")
    private Long harmId;

    /**
     * 监测周期（天）
     */
    @Column(name = "check_cycle")
    private Integer checkCycle;
    private String remark;

    /**
     * 检测( HC_CheckPlan 主键)   获取检测编号
     */
    @Column(name = "check_plan_id")
    private Long checkPlanId;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建人对应的部门
     */
    @Column(name = "org_id")
    private Long orgId;
    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

}