package cn.smarthse.modules.health.entity.work.evaluate;

import cn.smarthse.common.framework.service.IBaseService;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import lombok.Data;

@Data
@Table(name = "evaluate_third")
public class EvaluateThird implements Serializable {
    /**
     * ID
     */
    @Id
    @Column(name = "id")
    private Long id;

    /**
     * 企业ID
     */
    @Column(name = "cid")
    private Long cid;

    /**
     * 评价ID
     */
    @Column(name = "eid")
    private Long eid;
    /**
     * 检测ID
     */
    @Column(name = "checkplan_id")
    private Long checkplanId;

    /**
     * 委托单位id
     */
    @Column(name = "proxy_cid")
    private Long proxyCid;

    @Column(name = "proxy_cname")
    private String proxyCname;
    /**
     * 委托单位id
     */
    @Column(name = "evaluate_org_cid")
    private Long evaluateOrgCid;

    @Column(name = "evaluate_org_cname")
    private String evaluateOrgCname;

    /**
     * 项目地址
     */
    @Column(name = "project_area_id")
    private Long projectAreaId;

    /**
     * 项目详情地址
     */
    @Column(name = "project_area_address")
    private String projectAreaAddress;

    /**
     * 项目联系人
     */
    @Column(name = "project_contact")
    private String projectContact;

    /**
     * 联系电话
     */
    @Column(name = "project_contact_tel")
    private String projectContactTel;

    /**
     * 上报状态， 1草稿， 2已上报, 3 被退回
     */
    @Column(name = "upload_state")
    private Byte uploadState;

    /**
     * 登记人
     */
    @Column(name = "upload_person")
    private String uploadPerson;

    /**
     * 上报时间
     */
    @Column(name = "upload_date")
    private Date uploadDate;


    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;
}