package cn.smarthse.modules.health.entity.work.evaluate;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "evaluate_otherfile")
public class EvaluateOtherfile implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 评价id
     */
    @Column(name = "evaluate_id")
    private Long evaluateId;

    /**
     * 1职业病危害现状评价  2:职业病危害预评价   3:职业病危害控制效果评价
     */
    @Column(name = "evaluate_type")
    private Byte evaluateType;

    /**
     * 附件类别标识，见PDM或枚举
     */
    private Byte category;

    /**
     * 附件文件file.id
     */
    @Column(name = "attachment_fid")
    private String attachmentFid;

    /**
     * 纸质版存放位置
     */
    @Column(name = "paper_location")
    private String paperLocation;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取评价id
     *
     * @return evaluate_id - 评价id
     */
    public Long getEvaluateId() {
        return evaluateId;
    }

    /**
     * 设置评价id
     *
     * @param evaluateId 评价id
     */
    public void setEvaluateId(Long evaluateId) {
        this.evaluateId = evaluateId;
    }

    /**
     * 获取1职业病危害现状评价  2:职业病危害预评价   3:职业病危害控制效果评价
     *
     * @return evaluate_type - 1职业病危害现状评价  2:职业病危害预评价   3:职业病危害控制效果评价
     */
    public Byte getEvaluateType() {
        return evaluateType;
    }

    /**
     * 设置1职业病危害现状评价  2:职业病危害预评价   3:职业病危害控制效果评价
     *
     * @param evaluateType 1职业病危害现状评价  2:职业病危害预评价   3:职业病危害控制效果评价
     */
    public void setEvaluateType(Byte evaluateType) {
        this.evaluateType = evaluateType;
    }

    /**
     * 获取附件类别标识，见PDM或枚举
     *
     * @return category - 附件类别标识，见PDM或枚举
     */
    public Byte getCategory() {
        return category;
    }

    /**
     * 设置附件类别标识，见PDM或枚举
     *
     * @param category 附件类别标识，见PDM或枚举
     */
    public void setCategory(Byte category) {
        this.category = category;
    }

    /**
     * 获取附件文件file.id
     *
     * @return attachment_fid - 附件文件file.id
     */
    public String getAttachmentFid() {
        return attachmentFid;
    }

    /**
     * 设置附件文件file.id
     *
     * @param attachmentFid 附件文件file.id
     */
    public void setAttachmentFid(String attachmentFid) {
        this.attachmentFid = attachmentFid == null ? null : attachmentFid.trim();
    }

    /**
     * 获取纸质版存放位置
     *
     * @return paper_location - 纸质版存放位置
     */
    public String getPaperLocation() {
        return paperLocation;
    }

    /**
     * 设置纸质版存放位置
     *
     * @param paperLocation 纸质版存放位置
     */
    public void setPaperLocation(String paperLocation) {
        this.paperLocation = paperLocation == null ? null : paperLocation.trim();
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}