package cn.smarthse.modules.health.entity.work.evaluate;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import lombok.Data;

@Table(name = "evaluate_hd")
public @Data class EvaluateHd implements Serializable {
    @Id
    @Column(name = "ID")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业id
     */
    private Long cid;

    /**
     * 评价id
     */
    @Column(name = "evaluate_id")
    private Long evaluateId;

    /**
     * 隐患编号
     */
    @Column(name = "hd_no")
    private String hdNo;

    /**
     * 隐患名称
     */
    @Column(name = "hd_name")
    private String hdName;

    /**
     * 发现人
     */
    @Column(name = "find_sid")
    private Long findSid;

    /**
     * 发现人 姓名（可编辑）
     */
    @Column(name = "find_sname")
    private String findSname;

    /**
     * 发现时间
     */
    @Column(name = "find_time")
    private Date findTime;

    /**
     * 发现来源
     */
    @Column(name = "find_source")
    private String findSource;

    /**
     * 隐患位置
     */
    @Column(name = "hd_aid")
    private Long hdAid;

    /**
     * 隐患位置名称
     */
    @Column(name = "hd_aname")
    private String hdAname;

    /**
     * 隐患等级
     */
    @Column(name = "hd_level")
    private Byte hdLevel;

    /**
     * 隐患分类:
1:管理类、
2工业人员类、
3设备设施及物料类、
4场所环境类
     */
    @Column(name = "hd_category")
    private String hdCategory;

    /**
     * 隐患描述
     */
    @Column(name = "hd_desc")
    private String hdDesc;

    /**
     * 隐患相关资料
     */
    @Column(name = "hd_info_fid")
    private String hdInfoFid;

    /**
     * 整改负责人
     */
    @Column(name = "reform_leader_sid")
    private Long reformLeaderSid;

    /**
     * 整改负责人名称
     */
    @Column(name = "reform_leader_name")
    private String reformLeaderName;

    /**
     * 整改协作人
     */
    @Column(name = "reform_collaborator_sid")
    private String reformCollaboratorSid;

    /**
     * 整改期限
     */
    @Column(name = "reform_time")
    private Date reformTime;

    @Column(name = "reform_way")
    private String reformWay;
	@Transient
    private List<SysFileModel> reformWayFiles;
    @Column(name = "is_finish")
    private Boolean isFinish;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    
}