package cn.smarthse.modules.health.entity.work.evaluate;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.enums.evaluate.EvaluateTypeEnum;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public @Data class Evaluate implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 工作名称
     */
    @Column(name = "work_name")
    private String workName;

    /**
     * 评价类型
     */
    @Column(name = "evaluate_type")
    private Byte evaluateType;
    @Transient
    private String evaluateTypeName;
    public String getEvaluateTypeName() {
    	if(evaluateType==null) return "";
    	
    	return EvaluateTypeEnum.getEvaluateTypeName(this.evaluateType);
    }
    /**
     * 评价项目id
     */
    @Column(name = "evaluate_project_id")
    private Long evaluateProjectId;
    @Transient
    private String evaluateProjectName;

    /**
     * 评价开始时间
     */
    @Column(name = "evaluate_start_time")
    private Date evaluateStartTime;

    /**
     * 评价结束时间
     */
    @Deprecated
    @Column(name = "evaluate_end_time")
    private Date evaluateEndTime;

    /**
     * 负责人
     */
    @Column(name = "manager_sid")
    private Long managerSid;

    /**
     * 负责人姓名
     */
    @Column(name = "manager_name")
    private String managerName;

    /**
     * 服务机构名称
     */
    @Column(name = "service_id")
    private Long serviceId;
    @Transient
    private String serviceName;
    /**
     * 自行编制
     */
    @Column(name = "self_edit")
    private Boolean selfEdit;

    /**
     * 评价委托书
     */
    @Column(name = "evaluate_proxy_fid")
    private String evaluateProxyFid;
    @Transient
    private List<SysFileModel> evaluateProxyFileList;
    /**
     * 职业病危害控制效果评价报告
     */
    @Column(name = "occ_control_effect_fid")
    private String occControlEffectFid;
    
    /**
     * 评价报告 文件集合
     */
    @Transient
    private List<SysFileModel> evaluateReportFileList;
    /**
     * 评价报告 存放位置
     */
    @Transient
    private String evaluateReportLocation;
    /**
     * 纸质版存放位置
     */
    @Column(name = "occ_control_effect_location")
    private String occControlEffectLocation;

    /**
     * 报告评审时间
     */
    @Column(name = "report_review_time")
    private Date reportReviewTime;

    /**
     * 职业病危害类别   1一般  2较重    3严重
     */
    @Column(name = "occ_type")
    private Byte occType;

    /**
     * 职业病防护设施验收时间
     */
    @Column(name = "occ_shield_check_time")
    private Date occShieldCheckTime;

    /**
     * 存在的主要职业病危害因素
     */
    @Column(name = "main_occ_hazards")
    private String mainOccHazards;

    /**
     * 是否需要整改
     */
    @Column(name = "need_reform")
    private Boolean needReform;

    /**
     * 报告出具时间
     */
    @Column(name = "report_issue_date")
    private Date reportIssueDate;
    /**
     * 报告评审意见
     */
    @Column(name = "report_review_comments")
    private String reportReviewComments;

    /**
     * 是否完成
     */
    @Column(name = "is_finish")
    private Boolean isFinish;

    /**
     * 是否作废
     */
    @Column(name = "is_void")
    private Boolean isVoid;



    /**
     * 数据来源， 1企业端， 2机构端
     */
    @Column(name = "data_source")
    private Byte dataSource;

    /**
     * 完成时间
     */
    @Column(name = "finish_time")
    private Date finishTime;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人对应的部门
     */
    @Column(name = "org_id")
    private String orgId;
    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    @Transient
    private Boolean isHasBack;

    private static final long serialVersionUID = 1L;
    /**
     * 
     * 
     * @Comments:  <格式化危害因素- >
     * @author zhoulj(周利军) [1217102780@qq.com]
     * @since 2018年9月11日-上午9:04:43
     * @param MainOccHazards
     * @return
     */
    public String formatMainOccHazards(String mainOccHazards) {
    	if(StringUtils.isBlank(mainOccHazards)) return ""; 
    	String reg="([,])\\d{0,}:";//边界值的限定   //将对象封装成对象。   
	    Pattern p=Pattern.compile(reg);
	    while(true){    
	    	Matcher m=p.matcher(mainOccHazards); 
	    	if(m.find()) {
	    		mainOccHazards = mainOccHazards.substring(0, m.start())+"!##!"+mainOccHazards.substring(m.start()+1);//regxx(str,m);
	    	}else {
	    		break;
	    	}
	    }
	    return mainOccHazards;
    }

}