package cn.smarthse.modules.health.entity.work.eme;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 
 * 《EmeTeamMember》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <4.8.2>
 * @Comments:  <应急救援管理机构人员>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-6-8-下午5:09:10
 */
@Table(name = "eme_team_member")
public @Data class EmeTeamMember implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 机构ID
     */
    @Column(name = "dept_id")
    private Long deptId;

    /**
     * 人员信息ID
     */
    @Column(name = "staff_id")
    private Long staffId;

    /**
     * 上级职能机构人员
     */
    private Long pid;

    /**
     * 姓名
     */
    @Column(name = "member_name")
    private String memberName;

    /**
     * 本机构职务（1-组长、2-副组长、3-成员）
     */
    private Integer duty;

    /**
     * 公司职务
     */
    private String job;

    /**
     * 部门
     */
    private Long dept;
    
    /**
     *   部门名称
     */
    @Column(name = "dept_name")
    private String deptName;

    /**
     * 联系方式
     */
    private String tel;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;
    
    /**
     * 本机构职务（1-组长、2-副组长、3-成员）
     */
    @Transient
    private String dutyName;    
    
    
    /**
     *   上级领导名称
     */
    @Transient
    private String pidName;
}