package cn.smarthse.modules.health.entity.work.eme;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;

/**
 * 
 * 《EmeTeam》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <4.8.2>
 * @Comments:  <应急救援管理机构>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-6-8-下午5:09:10
 */
@Table(name = "eme_team")
public @Data class EmeTeam implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 成立文件
     */
    @Column(name = "dept_file")
    private String deptFile;

    /**
     * 成立时间
     */
    @Column(name = "setting_time")
    private Date settingTime;

    /**
     * 机构名称
     */
    @Column(name = "team_name")
    private String teamName;

    /**
     * 管理部门
     */
    @Column(name = "manage_dept")
    private String manageDept;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;
}