package cn.smarthse.modules.health.entity.work.eme;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 
 * 《EmeRescueTeamRerson》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <4.8.3>
 * @Comments:  <应急救援队伍人员>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-6-8-下午5:09:10
 */
@Table(name = "eme_rescue_team_rerson")
public @Data class EmeRescueTeamRerson implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 应急救援队伍ID
     */
    @Column(name = "team_id")
    private Long teamId;

    /**
     * 人员信息ID
     */
    @Column(name = "staff_id")
    private Long staffId;

    /**
     * 人员姓名
     */
    @Column(name = "person_name")
    private String personName;

    /**
     * 在本机构的职务
     */
    @Column(name = "person_duty")
    private String personDuty;

    /**
     * 部门/车间
     */
    @Column(name = "person_org")
    private String personOrg;

    /**
     * 公司职务
     */
    @Column(name = "person_job")
    private String personJob;

    /**
     * 岗位
     */
    @Column(name = "person_workrole")
    private String personWorkrole;

    /**
     * 联系电话
     */
    @Column(name = "person_tel")
    private String personTel;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 上级领导
     */
    private Long pid;
    
    /**
     * 在本机构的职务名称
     */
    @Transient
    private String personDutyName;
    
    private static final long serialVersionUID = 1L;
    
    public String getPersonDutyName() {
    	if("1".equals(personDuty)){
    		personDutyName = "组长";
		}else if("2".equals(personDuty)){
			personDutyName = "副组长";
		}else if("3".equals(personDuty)){
			personDutyName = "成员";
		}
    	return personDutyName;
    }
}