package cn.smarthse.modules.health.entity.work.eme;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;

/**
 * 
 * 《EmeRescueTeam》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <4.8.3>
 * @Comments:  <应急救援队伍>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-6-8-下午5:09:10
 */
@Table(name = "eme_rescue_team")
public @Data class EmeRescueTeam implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 应急救援队伍名称
     */
    @Column(name = "team_name")
    private String teamName;

    /**
     * 应急救援成立文件ID
     */
    @Column(name = "team_file_id")
    private Long teamFileId;

    /**
     * 应急救援队伍类型(1-自行成立,2-外协,3-合作成立)
     */
    @Column(name = "team_type")
    private Byte teamType;

    /**
     * 外协/合作单位
     */
    @Column(name = "out_company_name")
    private String outCompanyName;

    /**
     * 外协/合作开始时间
     */
    @Column(name = "start_time")
    private Date startTime;

    /**
     * 外协/合作结束时间
     */
    @Column(name = "end_time")
    private Date endTime;

    /**
     * 外协/合作周期
     */
    @Column(name = "out_cycle")
    private Integer outCycle;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;
    
    /**
     * 成立时间
     */
    @Column(name = "open_date")
    private Date openDate;
}