package cn.smarthse.modules.health.entity.work.eme;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;

/**
 * 
 * 《EmeRescueDeptPerson》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <4.8.4>
 * @Comments:  <职能机构人员>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-6-8-下午5:09:10
 */
@Table(name = "eme_rescue_dept_person")
public @Data class EmeRescueDeptPerson implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 应急救援职能部门ID
     */
    @Column(name = "dept_id")
    private Long deptId;

    /**
     * 职能职责
     */
    private String duty;

    /**
     * 部门ID
     */
    @Column(name = "org_id")
    private Long orgId;

    /**
     * 部门负责人员工ID
     */
    @Column(name = "org_charge_staff_id")
    private Long orgChargeStaffId;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;
    
    /**
     * 部门名称
     */    
    @Transient
    private String fullName;
    
    /**
     *   设置岗位信息表外键，对应岗位表主键
     */
    @Transient
    private Long rid;
    
    /**
     *   岗位名称
     */
    @Transient
    private String workName;
    
    /**
     *   企业员工信息表外键，对应用户基本信息表主键
     */
    @Transient
    private Long userbasicid;
    
    /**
     *   负责人
     */
    @Column(name = "real_name")
    private String realName;

    /**
     *   联系电话
     */
    private String phone;
    
    /**
     *   职务
     */
    @Column(name = "job_title")
    private String jobTitle;
}