package cn.smarthse.modules.health.entity.work.eme;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;

/**
 * 
 * 《EmeReportContact》
 * 
 * 
 * @Project:  smarthse-facade
 * @Module ID:   <4.8.5>
 * @Comments:  <上报联系单>
 * @JDK version used:      <JDK1.7> 
 * @author 徐颖东 [xyd.900919@qq.com]
 * @since 2017-6-8-下午5:09:10
 */
@Table(name = "eme_report_contact")
public @Data class EmeReportContact implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 姓名
     */
    @Column(name = "person_name")
    private String personName;

    /**
     * 公司职务
     */
    @Column(name = "person_job")
    private String personJob;

    /**
     * 联系电话
     */
    @Column(name = "person_tel")
    private String personTel;

    /**
     * 所在单位
     */
    @Column(name = "person_company")
    private String personCompany;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;
}