package cn.smarthse.modules.health.entity.work.eme;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "eme_drill_files")
public class EmeDrillFiles implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 演练id
     */
    @Column(name = "drill_id")
    private Long drillId;

    /**
     * 附件编号(File.ID)
     */
    @Column(name = "file_id")
    private Long fileId;

    /**
     * 附件地址
     */
    @Column(name = "file_url")
    private String fileUrl;

    /**
     * 附件名称
     */
    @Column(name = "file_name")
    private String fileName;

    /**
     * 附件类型(1-应急演练方案,2过程记录资料,3-总结,4-其他附件)
     */
    @Column(name = "file_type")
    private Byte fileType;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取演练id
     *
     * @return drill_id - 演练id
     */
    public Long getDrillId() {
        return drillId;
    }

    /**
     * 设置演练id
     *
     * @param drillId 演练id
     */
    public void setDrillId(Long drillId) {
        this.drillId = drillId;
    }

    /**
     * 获取附件编号(File.ID)
     *
     * @return file_id - 附件编号(File.ID)
     */
    public Long getFileId() {
        return fileId;
    }

    /**
     * 设置附件编号(File.ID)
     *
     * @param fileId 附件编号(File.ID)
     */
    public void setFileId(Long fileId) {
        this.fileId = fileId;
    }

    /**
     * 获取附件地址
     *
     * @return file_url - 附件地址
     */
    public String getFileUrl() {
        return fileUrl;
    }

    /**
     * 设置附件地址
     *
     * @param fileUrl 附件地址
     */
    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl == null ? null : fileUrl.trim();
    }

    /**
     * 获取附件名称
     *
     * @return file_name - 附件名称
     */
    public String getFileName() {
        return fileName;
    }

    /**
     * 设置附件名称
     *
     * @param fileName 附件名称
     */
    public void setFileName(String fileName) {
        this.fileName = fileName == null ? null : fileName.trim();
    }

    /**
     * 获取附件类型(1-应急演练方案,2过程记录资料,3-总结,4-其他附件)
     *
     * @return file_type - 附件类型(1-应急演练方案,2过程记录资料,3-总结,4-其他附件)
     */
    public Byte getFileType() {
        return fileType;
    }

    /**
     * 设置附件类型(1-应急演练方案,2过程记录资料,3-总结,4-其他附件)
     *
     * @param fileType 附件类型(1-应急演练方案,2过程记录资料,3-总结,4-其他附件)
     */
    public void setFileType(Byte fileType) {
        this.fileType = fileType;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}