package cn.smarthse.modules.health.entity.work.eme;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Table(name = "eme_drill")
public class EmeDrill implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 演练编号
     */
    private String no;

    /**
     * 演练名称
     */
    private String name;

    /**
     * 演练类型(1单项演练 2综合演练)
     */
    private Byte type;
    
    @Transient
    private String typeName;

    /**
     * 演练形式(1现场演练 2桌面演练)
     */
    private Byte form;

    /**
     * 计划演练时间
     */
    @Column(name = "plan_time")
    private Date planTime;

    /**
     * 演练开始时间
     */
    @Column(name = "start_time")
    private Date startTime;

    /**
     * 演练地点
     */
    private String location;

    /**
     * 负责人id
     */
    private Long manager;
    
    /**
     * 负责人名称
     * */
    @Transient
    private String managerName;

    /**
     * 检测经费预算
     */
    @Column(name = "plan_cost")
    private BigDecimal planCost;

    /**
     * 演练档案存放位置
     */
    @Column(name = "files_storage_location")
    private String filesStorageLocation;

    /**
     * 备注
     */
    private String remark;

    /**
     * 状态(0进行中 1已完成)
     */
    private Byte status;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 创建人对应的部门
     */
    @Column(name = "org_id")
    private String orgId;

    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    /**
     *方案 
     */
    @Transient
    private List<EmeDrillFiles> schemes = new ArrayList<EmeDrillFiles>();
    
    /**
     *记录 
     */
    @Transient
    private List<EmeDrillFiles> records = new ArrayList<EmeDrillFiles>();
    
    /**
     *总结
     */
    @Transient
    private List<EmeDrillFiles> sumarries = new ArrayList<EmeDrillFiles>();
    
    /**
     *其他附件 
     */
    @Transient
    private List<EmeDrillFiles> others = new ArrayList<EmeDrillFiles>();
    

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取演练编号
     *
     * @return no - 演练编号
     */
    public String getNo() {
        return no;
    }

    /**
     * 设置演练编号
     *
     * @param no 演练编号
     */
    public void setNo(String no) {
        this.no = no == null ? null : no.trim();
    }

    /**
     * 获取演练名称
     *
     * @return name - 演练名称
     */
    public String getName() {
        return name;
    }

    /**
     * 设置演练名称
     *
     * @param name 演练名称
     */
    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    /**
     * 获取演练类型(1单项演练 2综合演练)
     *
     * @return type - 演练类型(1单项演练 2综合演练)
     */
    public Byte getType() {
        return type;
    }

    /**
     * 设置演练类型(1单项演练 2综合演练)
     *
     * @param type 演练类型(1单项演练 2综合演练)
     */
    public void setType(Byte type) {
        this.type = type;
    }

    /**
     * 获取演练形式(1现场演练 2桌面演练)
     *
     * @return form - 演练形式(1现场演练 2桌面演练)
     */
    public Byte getForm() {
        return form;
    }

    /**
     * 设置演练形式(1现场演练 2桌面演练)
     *
     * @param form 演练形式(1现场演练 2桌面演练)
     */
    public void setForm(Byte form) {
        this.form = form;
    }

    /**
     * 获取计划演练时间
     *
     * @return plan_time - 计划演练时间
     */
    public Date getPlanTime() {
        return planTime;
    }

    /**
     * 设置计划演练时间
     *
     * @param planTime 计划演练时间
     */
    public void setPlanTime(Date planTime) {
        this.planTime = planTime;
    }

    /**
     * 获取演练开始时间
     *
     * @return start_time - 演练开始时间
     */
    public Date getStartTime() {
        return startTime;
    }

    /**
     * 设置演练开始时间
     *
     * @param startTime 演练开始时间
     */
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    /**
     * 获取演练地点
     *
     * @return location - 演练地点
     */
    public String getLocation() {
        return location;
    }

    /**
     * 设置演练地点
     *
     * @param location 演练地点
     */
    public void setLocation(String location) {
        this.location = location == null ? null : location.trim();
    }

    /**
     * 获取负责人id
     *
     * @return manager - 负责人id
     */
    public Long getManager() {
        return manager;
    }

    /**
     * 设置负责人id
     *
     * @param manager 负责人id
     */
    public void setManager(Long manager) {
        this.manager = manager;
    }

    /**
     * 获取检测经费预算
     *
     * @return plan_cost - 检测经费预算
     */
    public BigDecimal getPlanCost() {
        return planCost;
    }

    /**
     * 设置检测经费预算
     *
     * @param planCost 检测经费预算
     */
    public void setPlanCost(BigDecimal planCost) {
        this.planCost = planCost;
    }

    /**
     * 获取演练档案存放位置
     *
     * @return files_storage_location - 演练档案存放位置
     */
    public String getFilesStorageLocation() {
        return filesStorageLocation;
    }

    /**
     * 设置演练档案存放位置
     *
     * @param filesStorageLocation 演练档案存放位置
     */
    public void setFilesStorageLocation(String filesStorageLocation) {
        this.filesStorageLocation = filesStorageLocation == null ? null : filesStorageLocation.trim();
    }

    /**
     * 获取备注
     *
     * @return remark - 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 设置备注
     *
     * @param remark 备注
     */
    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    /**
     * 获取状态(0进行中 1已完成)
     *
     * @return status - 状态(0进行中 1已完成)
     */
    public Byte getStatus() {
        return status;
    }

    /**
     * 设置状态(0进行中 1已完成)
     *
     * @param status 状态(0进行中 1已完成)
     */
    public void setStatus(Byte status) {
        this.status = status;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

	public List<EmeDrillFiles> getSchemes() {
		return schemes;
	}

	public void setSchemes(List<EmeDrillFiles> schemes) {
		this.schemes = schemes;
	}

	public List<EmeDrillFiles> getRecords() {
		return records;
	}

	public void setRecords(List<EmeDrillFiles> records) {
		this.records = records;
	}

	public List<EmeDrillFiles> getSumarries() {
		return sumarries;
	}

	public void setSumarries(List<EmeDrillFiles> sumarries) {
		this.sumarries = sumarries;
	}

	public List<EmeDrillFiles> getOthers() {
		return others;
	}

	public void setOthers(List<EmeDrillFiles> others) {
		this.others = others;
	}

	public String getManagerName() {
		return managerName;
	}

	public void setManagerName(String managerName) {
		this.managerName = managerName;
	}

	public String getTypeName() {
		return typeName;
	}

	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}
    
}