package cn.smarthse.modules.health.entity.work.check.vo.doc;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import lombok.Data;

public @Data class Doc6Table4_2 implements Serializable{
	
	
	private static final long serialVersionUID = -4172887802146206992L;

	/**
	 * 疑似职业病名称/职业病名称
	 */
	private String diseaseName;
	/**
	 * 诊断日期
	 */
	private Date diagnosedTime;
	
	/**
	 * diagnosedTime字符串形式
	 */
	private String diagnosedTimeStr;
	
	/**
	 * 是否是职业病（false：否，true：是）
	 */
	private Boolean isDisease;
	
	/**
	 * 职业病诊断证明书
	 */
	private List<SysFileModel> certs;
	
	public String getDiagnosedTimeStr(){
		if(diagnosedTime == null){
			return "";
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		return sdf.format(this.diagnosedTime);
	}
}
