package cn.smarthse.modules.health.entity.work.check.vo.doc;

import java.io.Serializable;
import java.util.Date;

import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.health.enums.check.CheckTypeEnum;

public class Doc5Table3 implements Serializable{

	private static final long serialVersionUID = -1778089863065606821L;
	
	private Long checkId;
	private Date beginTime;
	private Date endTime;
	private String checkDate;
	private Byte checkType;
	private String checkTypeName;	
	private String staffDeptId;
	private String staffDeptName;
	private String reportLocation;	
	
	public Long getCheckId() {
		return checkId;
	}
	public void setCheckId(Long checkId) {
		this.checkId = checkId;
	}
	public Date getBeginTime() {
		return beginTime;
	}
	public void setBeginTime(Date beginTime) {
		this.beginTime = beginTime;
	}
	public Date getEndTime() {
		return endTime;
	}
	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}	
	public Byte getCheckType() {
		return checkType;
	}
	public void setCheckType(Byte checkType) {
		this.checkType = checkType;
	}
	
	public String getCheckDate() {
		if(this.beginTime==null||this.endTime==null) return checkDate;
		String pattern = "yyyy-MM-dd";
		checkDate = DateUtils.format(beginTime, pattern) + Constants.CHECK_TIME_SPLITOR + DateUtils.format(endTime, pattern);
		return checkDate;
	}
	public void setCheckDate(String checkDate) {
		this.checkDate = checkDate;
	}
	public String getCheckTypeName() {
		if(this.checkType!=null) this.checkTypeName = CheckTypeEnum.getName(String.valueOf(this.checkType));
		return checkTypeName;
	}
	public void setCheckTypeName(String checkTypeName) {
		this.checkTypeName = checkTypeName;
	}
	
	public String getReportLocation() {
		return reportLocation;
	}
	public void setReportLocation(String reportLocation) {
		this.reportLocation = reportLocation;
	}
	public String getStaffDeptId() {
		return staffDeptId;
	}
	public void setStaffDeptId(String staffDeptId) {
		this.staffDeptId = staffDeptId;
	}
	public String getStaffDeptName() {
		return staffDeptName;
	}
	public void setStaffDeptName(String staffDeptName) {
		this.staffDeptName = staffDeptName;
	}
	
}
