package cn.smarthse.modules.health.entity.work.check.vo.count;

import lombok.Data;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 《说明：》
 *
 * @author yanao
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments: <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @CopyRight CopyRright (c) 2015
 * @since 2019/8/28 17:27
 */
public @Data class CheckTypeCount implements Serializable {

    private Long id;

    private Long cid;

    private Long checkId;

    private String checkType;

    private String checkTypeName;
    /**
     * 应体检人数
     */
    private Integer needChecks;
    /**
     * 体检人数
     */
    private Integer checks;

    private Set<Long> checkStaffIds = new HashSet<>();
    /**
     * 体检人数（男）
     */
    private Integer men;
    private Set<Long> manStaffIds = new HashSet<>();
    /**
     * 体检人数（女）
     */
    private Integer women;
    private Set<Long> womenStaffIds = new HashSet<>();
    /**
     * 疑似职业病人数
     */
    private Integer sd;
    private Set<Long> sdStaffIds = new HashSet<>();
    /**
     * 职业禁忌证人数
     */
    private Integer oc;
    private Set<Long> ocStaffIds = new HashSet<>();
    /**
     * 复查人数
     */
    private Integer recheck;
    private Set<Long> recheckStaffIds = new HashSet<>();
    /**
     * 缺必检项人数
     */
    private Integer missing;
    private Set<Long> missingStaffIds = new HashSet<>();
    /**
     * 危害因素id
     */
    private String harmIds;
    private String harmNames;
    /**
     * 体检项目
     */
    private String checkProjects;
    /**
     * 体检报告id
     */
    private String checkReportFileIds;
    /**
     * 其他附件id
     */
    private String otherFileIds;
    public Integer getChecks() {
        checks = checkStaffIds.size();
        return checks;
    }

    public Integer getMen() {
        men = manStaffIds.size();
        return men;
    }

    public Integer getWomen() {
        women = womenStaffIds.size();
        return women;
    }

    public Integer getSd() {
        sd = sdStaffIds.size();
        return sd;
    }

    public Integer getOc() {
        oc = ocStaffIds.size();
        return oc;
    }

    public Integer getRecheck() {
        recheck = recheckStaffIds.size();
        return recheck;
    }

    public Integer getMissing() {
        missing = missingStaffIds.size();
        return missing;
    }

}
