package cn.smarthse.modules.health.entity.work.check.vo;

import java.io.Serializable;

import lombok.Data;

public @Data class PhcYearCheckInfo implements Serializable{

	private static final long serialVersionUID = 1214504422702153696L;
	
	private Long checkId;
	
	private Integer year;
	
	private Integer beginYear;
	
	private Integer endYear;
	
	private Long cid;
	/**
	 * 体检次数
	 * */
	private Integer checkTimes = 0;
	/**
	 * 体检人次（同一个人不同体检类型算两次，一个体检类型里算一次）
	 * */
	private Integer checkStaffs = 0;	
	/**
	 * 职业病人数
	 * */
	private Integer diseasers = 0;	
	/**
	 * 确诊的职业病人数
	 * */
	private Integer diagnoseDiseasers = 0;
	/**
	 * 未见异常人数
	 * */
	private Integer normal = 0;
	/**
	 * 复查人数
	 * */
	private Integer recheck = 0;
	
	/**
	 * 疑似职业病人数
	 * */
	private Integer sd = 0;
	
	/**
	 * 新增的疑似职业病人数
	 * */
	private Integer newSd = 0;
	
	/**
	 * 其他人数
	 * */
	private Integer other = 0;
	/**
	 * 职业禁忌人数
	 * */
	private Integer oc = 0;
	
	/**
	 * 体检总人数
	 * */
	private Integer checkCount = 0;
	
	/**
	 * 体检结果总数
	 * */
	private Integer resultCount = 0;

	/**
	 * 缺必检项
	 */
	private Integer missing = 0;

	/**
	 * 类型（1、诊断 2、鉴定）
	 */
	private Byte diagnosedType;
	
}
