package cn.smarthse.modules.health.entity.work.check.vo;

import java.io.Serializable;
import java.util.Date;

import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.health.enums.check.CheckTypeEnum;

public class PhcPhysicalQueryCheckInfo implements Serializable{		

	private static final long serialVersionUID = 2855293763003597567L;
	private Long checkId;
	private Date beginTime;
	private Date endTime;
	/**
	 * 体检日期
	 * */
	private String checkDate;
	/**
	 * 体检编号
	 * */
	private String checkNo;
	private Long hospital;
	/**
	 * 检查机构
	 * */
	private String hospitalName;
	private Byte checkType;
	/**
	 * 体检种类
	 * */
	private String checkTypeName;
	
	private Integer needCheckTotal = 0;
	
	private String reportLocation;
	
	/**
	 * 体检人数
	 * */
	private Integer total = 0;
	/**
	 * 未见异常人数
	 * */
	private Integer normal = 0;
	/**
	 * 复查人数
	 * */
	private Integer recheck = 0;
	
	/**
	 * 疑似职业病人数
	 * */
	private Integer sd = 0;
	
	/**
	 * 其他人数
	 * */
	private Integer other = 0;
	/**
	 * 职业禁忌人数
	 * */
	private Integer oc = 0;
	public Long getCheckId() {
		return checkId;
	}
	public void setCheckId(Long checkId) {
		this.checkId = checkId;
	}
	public Date getBeginTime() {
		return beginTime;
	}
	public void setBeginTime(Date beginTime) {
		this.beginTime = beginTime;
	}
	public Date getEndTime() {
		return endTime;
	}
	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}
	public String getCheckNo() {
		return checkNo;
	}
	public void setCheckNo(String checkNo) {
		this.checkNo = checkNo;
	}
	public Long getHospital() {
		return hospital;
	}
	public void setHospital(Long hospital) {
		this.hospital = hospital;
	}
	public String getHospitalName() {
		return hospitalName;
	}
	public void setHospitalName(String hospitalName) {
		this.hospitalName = hospitalName;
	}
	public Byte getCheckType() {
		return checkType;
	}
	public void setCheckType(Byte checkType) {
		this.checkType = checkType;
	}
	public Integer getTotal() {
		return total;
	}
	public void setTotal(Integer total) {
		this.total = total;
	}
	public Integer getNormal() {
		return normal;
	}
	public void setNormal(Integer normal) {
		this.normal = normal;
	}
	public Integer getRecheck() {
		return recheck;
	}
	public void setRecheck(Integer recheck) {
		this.recheck = recheck;
	}
	public Integer getSd() {
		return sd;
	}
	public void setSd(Integer sd) {
		this.sd = sd;
	}
	public Integer getOther() {
		return other;
	}
	public void setOther(Integer other) {
		this.other = other;
	}
	public Integer getOc() {
		return oc;
	}
	public void setOc(Integer oc) {
		this.oc = oc;
	}
	public String getCheckDate() {
		if(this.beginTime==null||this.endTime==null) return checkDate;
		String pattern = "yyyy-MM-dd";
		checkDate = DateUtils.format(beginTime, pattern) + Constants.CHECK_TIME_SPLITOR + DateUtils.format(endTime, pattern);
		return checkDate;
	}
	public void setCheckDate(String checkDate) {
		this.checkDate = checkDate;
	}
	public String getCheckTypeName() {
		if(this.checkType!=null) this.checkTypeName = CheckTypeEnum.getName(String.valueOf(this.checkType));
		return checkTypeName;
	}
	public void setCheckTypeName(String checkTypeName) {
		this.checkTypeName = checkTypeName;
	}

	public Integer getNeedCheckTotal() {
		return needCheckTotal;
	}
	public void setNeedCheckTotal(Integer needCheckTotal) {
		this.needCheckTotal = needCheckTotal;
	}
	public String getReportLocation() {
		return reportLocation;
	}
	public void setReportLocation(String reportLocation) {
		this.reportLocation = reportLocation;
	}
	
}
