package cn.smarthse.modules.health.entity.work.check.vo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import lombok.Data;

public @Data class PhcPhysicalPersonInfo implements Serializable {
	
	private static final long serialVersionUID = 1706448056536299677L;

	/**
	 * 体检/职业病诊断/职业病人id
	 */
	private Long detailId;
	/**
	 * 体检id
	 */
	private Long checkId;
	/**
	 * 体检时间
	 */
	private String checkDate;
	/**
	 * 体检种类
	 */
	private String checkType;
	/**
	 * 体检结果
	 */
	private String checkResult;
	/**
	 * 结论详情（/work/check/data/result/deal/info?id=1）
	 */
	private String resultUrl;
	/**
	 * 体检机构
	 */
	private String hospitalName;
	/**
	 * 部门
	 */
	private String deptName;
	/**
	 * 岗位
	 */
	private String workName;
	/**
	 * 人员处理情况
	 */
	private String dealTypInfo;
	/**
	 * 情况说明
	 */
	private String infoDesc;
	/**
	 * 人员处理落实情况
	 */
	private String isSure;
	/**
	 * 现场处理情况
	 */
	private String dealDesc;

	/**
	 * 体检/职业病诊断/职业病人详情
	 */
	private String detailUrl;

	/**
	 * 所在单位
	 */
	private String companyName;
	/**
	 * 异常指标
	 */
	private String abnormal;
	/**
	 * 处理意见
	 */
	private String checkAdvise;

	/**
	 * 体检机构id
	 */
	private Long hospital;
	//人员姓名
	private String staffName;
	//工号
	private String workNo;

	private Byte confirmation;

	private String resultId;

	//个人体检报告
	private String reportFiles;

	private List<SysFileModel> reportFileList = new ArrayList<>();

}
