package cn.smarthse.modules.health.entity.work.check.vo;

import java.io.Serializable;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.enums.check.CheckTypeEnum;
import cn.smarthse.modules.health.enums.check.DealTypeEnum;
import cn.smarthse.modules.health.enums.check.ExamResultEnum;
import lombok.Data;

public @Data class PhcPhysicalPersonCheckInfo implements Serializable {
	
	private static final long serialVersionUID = -7781200054974942997L;
	private Long id;
	private Long checkId;
	private String checkDate;
	private String checkType;
	private String checkResult;	
	private String hospitalName;
	private String deptName;
	private String workName;
	private String resultId;
	private String infoDesc;
	private String dealDesc;
	private String dealType;
	private String isRecheck;
	private String recheckStatus;//是否复查（0未完成、1已完成）
	private Boolean isExchange;//是否转岗（false未完成、true已完成）
	private Boolean isDiagnosed;//是否进行职业病诊断（false未完成、true已完成）
	private String dealTypeInfo;
	private String pdInfoDesc;
	private String pdDealDesc;
	private Boolean isSure;
	private Boolean isDisease;
	private String diagnosedTime;
	private String diagnosedName;
	private String pWorkName;
	private String diseaseName;
    private String reportLocation;
    private String from;//来源（c:体检；p：职业病诊断；o：职业病人）
    private Long hospital;
    private String companyName;
    private String checkAdvice;
    private String abnormal;

    private String checkTypeName;
    private String dealTypInfo;
    private String checkResultName;
    private String reportFiles;

    private Byte confirmation;

    public String getCheckTypeName() {
        checkTypeName = CheckTypeEnum.getName(checkType);
        return checkTypeName;
    }

    public String getDealTypInfo() {
        dealTypInfo = getDealInfo(DealTypeEnum.getName(dealType), infoDesc);
		return dealTypInfo;
	}
	private String getDealInfo(String dealType,String infoDesc) {
		String result = "-";
		if(StringUtils.isNotEmpty(dealType)&&StringUtils.isNotEmpty(infoDesc)){
			result = dealType+"；"+infoDesc;
		}else if(StringUtils.isNotEmpty(dealType)){
			result = dealType;
		}else if(StringUtils.isNotEmpty(infoDesc)){
			result = infoDesc;
		}
		return result;
	}
	public String getCheckResultName() {
		checkResultName = ExamResultEnum.getName(checkResult);
		return checkResultName;
	}
}
