package cn.smarthse.modules.health.entity.work.check.vo;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.entity.work.check.PhcPhysicalCheckFile;
import cn.smarthse.modules.health.enums.check.CheckTypeEnum;

public class PhcPhysicalCheckConfiredInfo implements Serializable {
	

	private static final long serialVersionUID = 1L;
	
	private Long checkId;
	
	/**
	 * 编号
	 * */
	private String checkNo;
	/**
	 * 名称
	 * */
	private String checkName;
	/**
	 * 体检时间
	 * */
	private String checkDate;
	
	private Long managerId;
	
	private String managerName;
	
	private String checkType;
	
	/**
	 * 体检类型名称
	 * */
	private String checkTypeName = "";
	
	/**
	 * 告知凭证（前端通过fileId获取文件信息）
	 * */
	private List<PhcPhysicalCheckFile> files;
	
	/**
	 * 体检结果书面告知员工凭证存放位置
	 */
	private String filesStorageLocation;
	
	private String fileNames = "";
	
	private Date checkBeginTime;

	public Long getCheckId() {
		return checkId;
	}

	public void setCheckId(Long checkId) {
		this.checkId = checkId;
	}

	public String getCheckNo() {
		return checkNo;
	}

	public void setCheckNo(String checkNo) {
		this.checkNo = checkNo;
	}

	public String getCheckName() {
		return checkName;
	}

	public void setCheckName(String checkName) {
		this.checkName = checkName;
	}

	public String getCheckDate() {
		return checkDate;
	}

	public void setCheckDate(String checkDate) {
		this.checkDate = checkDate;
	}

	public String getCheckType() {
		return checkType;
	}

	public void setCheckType(String checkType) {
		this.checkType = checkType;
	}

	public String getCheckTypeName() {
		if(StringUtils.isEmpty(this.checkType)){
			return checkTypeName;			
		}
		String[] checkTypes = this.checkType.split(",");
		if(checkTypes==null||checkTypes.length==0) return  checkTypeName;
		checkTypeName = "";
		for(String ck:checkTypes) {
			this.checkTypeName += CheckTypeEnum.getName(ck)+" ";
		}		
		return checkTypeName;
	}

	public void setCheckTypeName(String checkTypeName) {
		this.checkTypeName = checkTypeName;
	}

	public List<PhcPhysicalCheckFile> getFiles() {
		return files;
	}

	public void setFiles(List<PhcPhysicalCheckFile> files) {
		this.files = files;
	}

	public String getManagerName() {
		return managerName;
	}

	public void setManagerName(String managerName) {
		this.managerName = managerName;
	}

	public String getFileNames() {
		if(this.files==null) return this.fileNames;
		for(PhcPhysicalCheckFile file:this.files) {
			fileNames += file.getFileName()+" ";
		}
		return fileNames;
	}

	public void setFileNames(String fileNames) {
		this.fileNames = fileNames;
	}

	public String getFilesStorageLocation() {
		return filesStorageLocation;
	}

	public void setFilesStorageLocation(String filesStorageLocation) {
		this.filesStorageLocation = filesStorageLocation;
	}

	public Long getManagerId() {
		return managerId;
	}

	public void setManagerId(Long managerId) {
		this.managerId = managerId;
	}

	public Date getCheckBeginTime() {
		return checkBeginTime;
	}

	public void setCheckBeginTime(Date checkBeginTime) {
		this.checkBeginTime = checkBeginTime;
	}
		
}
