package cn.smarthse.modules.health.entity.work.check.vo;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;

public class PhcDiseaserConfirmedDetail implements Serializable{
	
	private static final long serialVersionUID = 6955015305689107374L;
	/**
	 * 诊断id或职业病人id
	 */
	private Long diseaserId;
	private Long staffId;
	private String staffName;
	private String gender;
	private Date birthday;
	private String staffWorkNo;	
	private Long staffDeptId;
	/**
	 * 部门/车间
	 */
	private String staffDeptName;
	private Long staffWorkId;
	/**
	 * 岗位/工种
	 */
	private String staffWorkName;
	/**
	 * 疑似职业病名称/职业病名称
	 */
	private String diseaseName;
	/**
	 * 诊断日期
	 */
	private Date diagnosedTime;
	/**
	 * 诊断机构
	 */
	private String diagnosedName;
	
	private String level;
	/**
	 * 诊断级别
	 */
	private String diagnosedLevel;
	
	/**
	 * 是否是职业病（false：否，true：是）
	 */
	private Boolean isDisease;
	private String credenceUrl;
	
	private List<Long> credenceIds;
	
	private String certUrl;
	/**
	 * 告知凭证
	 */
	private List<SysFileModel> credenceFiles;
	
	private String credenceFileNames;
	public Long getDiseaserId() {
		return diseaserId;
	}
	public void setDiseaserId(Long diseaserId) {
		this.diseaserId = diseaserId;
	}
	public Long getStaffId() {
		return staffId;
	}
	public void setStaffId(Long staffId) {
		this.staffId = staffId;
	}
	public String getStaffName() {
		return staffName;
	}
	public void setStaffName(String staffName) {
		this.staffName = staffName;
	}
	public String getGender() {
		return gender;
	}
	public void setGender(String gender) {
		this.gender = gender;
	}
	public Date getBirthday() {
		return birthday;
	}
	public void setBirthday(Date birthday) {
		this.birthday = birthday;
	}
	public String getStaffWorkNo() {
		return staffWorkNo;
	}
	public void setStaffWorkNo(String staffWorkNo) {
		this.staffWorkNo = staffWorkNo;
	}
	public Long getStaffDeptId() {
		return staffDeptId;
	}
	public void setStaffDeptId(Long staffDeptId) {
		this.staffDeptId = staffDeptId;
	}
	public String getStaffDeptName() {
		return staffDeptName;
	}
	public void setStaffDeptName(String staffDeptName) {
		this.staffDeptName = staffDeptName;
	}
	public Long getStaffWorkId() {
		return staffWorkId;
	}
	public void setStaffWorkId(Long staffWorkId) {
		this.staffWorkId = staffWorkId;
	}
	public String getStaffWorkName() {
		return staffWorkName;
	}
	public void setStaffWorkName(String staffWorkName) {
		this.staffWorkName = staffWorkName;
	}
	public String getDiseaseName() {
		return diseaseName;
	}
	public void setDiseaseName(String diseaseName) {
		this.diseaseName = diseaseName;
	}
	public Date getDiagnosedTime() {
		return diagnosedTime;
	}
	public void setDiagnosedTime(Date diagnosedTime) {
		this.diagnosedTime = diagnosedTime;
	}
	public String getDiagnosedName() {
		return diagnosedName;
	}
	public void setDiagnosedName(String diagnosedName) {
		this.diagnosedName = diagnosedName;
	}
	public String getLevel() {
		return level;
	}
	public void setLevel(String level) {
		this.level = level;
	}
	public String getDiagnosedLevel() {		
		if(this.isDisease==null||!this.isDisease){
			diagnosedLevel = "非职业病";
		}else {
			diagnosedLevel = this.level;
		}
		return diagnosedLevel;
	}
	public void setDiagnosedLevel(String diagnosedLevel) {
		this.diagnosedLevel = diagnosedLevel;
	}
	public Boolean getIsDisease() {
		return isDisease;
	}
	public void setIsDisease(Boolean isDisease) {
		this.isDisease = isDisease;
	}
	public String getCredenceUrl() {
		return credenceUrl;
	}
	public void setCredenceUrl(String credenceUrl) {
		this.credenceUrl = credenceUrl;
	}
	public List<SysFileModel> getCredenceFiles() {
		return credenceFiles;
	}
	public void setCredenceFiles(List<SysFileModel> credenceFiles) {
		this.credenceFiles = credenceFiles;
	}
	public String getCertUrl() {
		return certUrl;
	}
	public void setCertUrl(String certUrl) {
		this.certUrl = certUrl;
	}
	public List<Long> getCredenceIds() {
		this.credenceIds = StringUtils.parseToLongList(this.credenceUrl, ",");
		return credenceIds;
	}
	public void setCredenceIds(List<Long> credenceIds) {
		this.credenceIds = credenceIds;
	}
	public String getCredenceFileNames() {
		return credenceFileNames;
	}
	public void setCredenceFileNames(String credenceFileNames) {
		this.credenceFileNames = credenceFileNames;
	}
	
}
