package cn.smarthse.modules.health.entity.work.check.checkV3221;

import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.IDCardUtil;
import cn.smarthse.common.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 体检人员体检信息
 */
@Table(name = "phc_physical_staff_check_info_v3221")
public @Data
class PhcPhysicalStaffCheckInfo implements Serializable {

    @Id
    private Long id;

    /**
     * wanda_health_card.source_id (机构端上报时为对应的人员信息表id)
     */
    private String cardId;
    @Transient
    private String otherHazardName;

    /**
     * 主表ID（phc_physical_check_v3221.id）
     */
    private Long sourceId;

    private String name;

    private String sexCode;

    private Integer age;

    private String birthday;

    private String jobCode;

    private String contactHazardCode;

    private String hazardYear;

    private String hazardMonth;

    //体检结论编码 详情见 PhyPhcCheckConclusionEnum
    private String conclusion;

    private String itemId;

    private String checkResultCode;

    private String suggest;

    private String creditCode;

    private String orgCode;

    private String creditCodeEmployer;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date checkTime;

    @Column(name = "body_check_type")
    private String bodyCheckType;

    private String workshop;

    @Column(name = "idcard_type")
    private String idcardType;

    @Column(name = "idcard_code")
    private String idcardCode;
    @Transient
    private String idCardMix;

    private String jobNumber;

    private Long createBy;

    private Date createDate;

    private Long updateBy;

    private Date updateDate;

    private Boolean isValid;

    /**
     * 其他工种名称
     */
    private String otherJobName;

    /**
     * 放射工种编码
     */
    private String radiationType;

    /**
     * 其他危害因素具体名称
     */
    private String contactOtherHazardName;

    /**
     * 其他项目名称
     */
    private String qttjxmmc;

    /**
     * 项目组合名称
     */
    private String itemGroupName;

    /**
     * 异常指标
     */
    private String anomalyItems;

    /**
     * 职业禁忌证编码
     */
    private String cotId;

    /**
     * 疑似职业病编码
     */
    private String sptId;

    /**
     * 其他疾病名称
     */
    private String otherDisease;

    /**
     * 体检诊断结论ID
     */
    private String diagnosisId;

    /**
     * 婚姻状态 WandaStaffMaritalStatusEnum 枚举
     */
    private String maritalStatusCode;

    /**
     * 联系电话
     */
    private String telPhone;

    private Long cid;

    private Long actualEmployerId;
    private String actualEmployerName;
    private String handlingOpinions;
    private String advice;
    private String fcItem;

    @Transient
    private String employerName;

    @Transient
    private String employerNameEmployer;

    @Transient
    private String areaNameEmployer;

    @Transient
    private String contactHazardName;
    @Transient
    private Integer checkYear;

    @Transient
    private String conclusionName;
    @Transient
    private String orgName;
    @Transient
    private String hazardCode;

    @Transient
    private Byte dataSource;

    @Transient
    private String writeDate;

    public String getIdCardMix(){
        if (StringUtils.isNotBlank(idcardCode)){
            return IDCardUtil.idCardMask(idcardCode);
        }
        return idcardCode;
    }

    public void setSexCode(String sexCode) {
        if ("1".equals(sexCode)) this.sexCode="男";
        else if ("2".equals(sexCode)) this.sexCode="女";
        else if ("男".equalsIgnoreCase(sexCode) || "女".equalsIgnoreCase(sexCode)) this.sexCode=sexCode;
//        else {
//            String sexStr = "男";
//            if ("2".equals(sexCode)) {
//                sexStr = "女";
//            }
//            this.sexCode = sexStr;
//        }

    }

}
