package cn.smarthse.modules.health.entity.work.check.checkV3221;


import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;

/**
 * 体检用工单位信息
 */
@Table(name = "phc_physical_employer_info_v3221")
public @Data
class PhcPhysicalEmployerInfo implements Serializable {

    @Id
    private Long id;

    /**
     * 用工单位统一社会信用代码
     */
    @Column(name = "credit_code_employer")
    private String creditCodeEmployer;

    /**
     * 用工单位名称
     */
    @Column(name = "employer_name_employer")
    private String employerNameEmployer;

    /**
     * 用工单位企业（经济）类型代码
     */
    @Column(name = "economic_type_code_employer")
    private String economicTypeCodeEmployer;

    /**
     * 用工单位行业类别代码
     */
    @Column(name = "ygdwhylbdm")
    private String ygdwhylbdm;

    /**
     * 用工单位企业规模代码
     */
    @Column(name = "enterprise_size_code_employer")
    private String enterpriseSizeCodeEmployer;

    /**
     * 用工单位所属地区代码
     */
    @Column(name = "area_code_employer")
    private String areaCodeEmployer;

    /**
     * 用工单位所在区全名称
     */
    @Column(name = "area_name_employer")
    private String areaNameEmployer;

    private Long createBy;

    private Date createDate;

    private Long updateBy;

    private Date updateDate;

    private Boolean isValid;

    @Transient
    private Date checkTime;

}
