package cn.smarthse.modules.health.entity.work.check.checkV3221;


import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;

/**
 * 体检列表信息
 */
@Table(name = "phc_physical_check_v3221")
public @Data
class PhcPhysicalCheckV3221 implements Serializable {

    @Id
    private Long id;

    /**
     * 体检年份
     */
    @Column(name = "check_year")
    private Integer checkYear;

    @Column(name = "check_time")
    private Date checkTime;

    @Column(name = "body_check_type")
    private Integer bodyCheckType;

    @Column(name = "org_code")
    private String orgCode;

    @Column(name = "org_name")
    private String orgName;

    @Column(name = "number_of_check")
    private Integer numberOfCheck = 0;

    @Column(name = "number_of_yszyb")
    private Integer numberOfYszyb = 0;

    @Column(name = "number_of_ysjjz")
    private Integer numberOfYsjjz = 0;

    @Column(name = "number_of_reexamination")
    private Integer numberOfReexamination = 0;

    @Column(name = "number_of_man")
    private Integer numberOfMan = 0;

    @Column(name = "number_of_woman")
    private Integer numberOfWoman = 0;

    @Column(name = "number_of_xfc")
    private Integer numberOfXfc = 0;

    /**
     * 企业统一信用代码
     */
    @Column(name = "credit_code")
    private String creditCode;

    @Column(name = "employer_name")
    private String employerName;

    @Column(name = "cid")
    private Long cid;

    /**
     * 上报时间/数据更新时间
     */
    @Column(name = "load_time")
    private Date loadTime;

    private Long createBy;

    private Date createDate;

    private Long updateBy;

    private Date updateDate;

    private Boolean isValid;

    @Transient
    private String bodyCheckTypeStr;

    @Column(name = "data_source")
    private Byte dataSource=1;

    /*************************** 以下字段为监管端上报时使用 ******************************/
    private String employerId;

    //是否复查
    private Boolean isRecheck;
    // 0-草稿，1-已上报 （机构端）
    private Byte status;
    private Date endTime;

    //应检人数
    private Integer numberOfShouldCheck;
    private String checkName;

    private String reportFileId;
    private String checkAddress;

    private Long sourceId;

    //委托单位
    private Long entrustEmployerId;
    //体检项目
    private String checkItems;

    @Transient
    private Long cardId;

}
