package cn.smarthse.modules.health.entity.work.check.checkV3221;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 体检查询Vo （V3221）
 */
public @Data
class PhcPhysicalCheckSearchVo implements Serializable {

    private Long id;

    private String cardId;

    private Long cid;
    private Long checkStaffId;

    private String unifiedSocialCc;
    /**
     * 身份证
     */
    private String idcardCode;

    private String companyName;

    private Long areaId;

    private Byte areaLevel;

    private Integer year;

    private Integer month;

    private Byte bodyCheckType;

    private String keyword;

    private Date startDate;

    private Date endDate;

    private Integer startYear;

    /**
     * 危害因素编号
     */
    private String hazardCode;

    /**
     * 危害因素名称
     */
    private String hazardName;

    /**
     * 体检结论编码   1、正常    2、复查    3、疑似职业病     4、职业禁忌证     5、其他疾病或异常
     *  6、（3、4）  7、（1、5）
     */
    private Byte conclusion;

    /**
     * 结果是否包括疑似职业病
     */
    private Boolean hasYszyb;

    /**
     * 结果是否包括疑似禁忌症
     */
    private Boolean hasYsjjz;

    /**
     * 是否包括复查
     */
    private Boolean hasFc;

    private List<String> hazardCodeList;

    private Byte dataSource;

    /**
     * phc_physical_staff_check_info_v3221.body_check_type
     */
    private Integer checkType;
    private List<Integer> checkTypeList;
    /**
     * phc_physical_check_outpack_company_match.matching_type
     */
    private String matchingType;
    /**
     * phc_physical_check_outpack_company_match.audit_type
     */
    private String auditType;
    /**
     * 体检数据匹配工作清单id -> phc_physical_check_outpack_company_match_work_list.id
     */
    private Long workListId;

}
