package cn.smarthse.modules.health.entity.work.check.checkV3221;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * @Author: DengJia
 * @Date: 2023/7/11
 * @Description: 体检数据匹配工作清单
 */

@Table(name = "phc_physical_check_outpack_company_match_work_list")
@Data
public class PhcPhysicalCheckOutpackCompanyMatchWorkList implements Serializable {
    private static final long serialVersionUID = 1167239344507412931L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;
    /**
     * 区域id
     */
    @Column(name = "area_id")
    private Long areaId;
    /**
     * 分配时间
     */
    @Column(name = "match_time")
    private Date matchTime;
    /**
     * 劳务派遣单位cid
     */
    @Column(name = "outpack_cid")
    private Long outpackCid;
    /**
     * 劳务派遣单位 统一社会信用代码
     */
    @Column(name = "outpack_ucc")
    private String outpackUcc;
    /**
     * 劳务派遣单位名称
     */
    @Column(name = "outpack_name")
    private String outpackName;
    /**
     * 劳务派遣单位地址
     */
    @Column(name = "outpack_address")
    private String outpackAddress;
    /**
     * 匹配类型 0草稿/待匹配 1完成匹配
     */
    @Column(name = "match_state")
    private Byte matchState;

    private String createDate;
    private String createBy;
    private String updateDate;
    private String updateBy;
    private String isValid;
}
