package cn.smarthse.modules.health.entity.work.check.checkV3221;

import lombok.Data;

import javax.persistence.*;
import java.util.Date;

/**
 * @Author: DengJia
 * @Date: 2023/7/11
 * @Description: 劳务派遣员工匹配实际用工单位表
 */

@Table(name = "phc_physical_check_outpack_company_match")
@Data
public class PhcPhysicalCheckOutpackCompanyMatch {

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;
    /**
     * 万达体检人员体检信息表（V3221）主键
     */
    @Column(name = "staff_check_id")
    private Long staffCheckId;
    /**
     * 员工姓名
     */
    @Column(name = "staff_name")
    private String staffName;
    /**
     * 身份证
     */
    @Column(name = "id_card")
    private String idCard;
    /**
     * 匹配类型 0无需匹配 1完成匹配
     */
    @Column(name = "matching_type")
    private Byte matchingType;
    /**
     * 审核类型 0待审 1已审
     */
    @Column(name = "auditType")
    private Byte auditType;
    /**
     * phc_physical_check_outpack_company_match_work_list.id
     */
    @Column(name = "match_work_list_id")
    private Long matchWorkListId;
    /**
     * 体检日期
     */
    @Column(name = "check_time")
    private Date checkTime;
    /**
     * 体检类型
     */
    @Column(name = "body_check_type")
    private Integer bodyCheckType;
    /**
     * 体检结论编码 1正常 2复查 3疑似职业病 4职业禁忌证 5其他疾病或异常 6、（3、4）  7、（1、5）
     */
    @Column(name = "conclusion")
    private String conclusion;
    /**
     * 主表ID phc_physical_check_v3221.id
     */
    @Column(name = "source_id")
    private Long sourceId;
    /**
     * 体检机构编码
     */
    @Column(name = "org_code")
    private String orgCode;
    /**
     * 劳务派遣单位cid
     */
    @Column(name = "outpack_cid")
    private Long outpackCid;
    /**
     * 劳务派遣单位 统一社会信用代码
     */
    @Column(name = "outpack_ucc")
    private String outpackUcc;
    /**
     * 劳务派遣单位名称
     */
    @Column(name = "outpack_name")
    private String outpackName;
    /**
     * 实际用工单位cid
     */
    @Column(name = "company_cid")
    private Long companyCid;
    /**
     * 实际用工单位 统一社会信用代码
     */
    @Column(name = "company_ucc")
    private String companyUcc;
    /**
     * 实际用工单位名称
     */
    @Column(name = "company_name")
    private String companyName;

    private String createDate;
    private String createBy;
    private String updateDate;
    private String updateBy;
    private String isValid;
}
