package cn.smarthse.modules.health.entity.work.check;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.*;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.health.enums.check.CheckTypeEnum;

@Table(name = "phc_physical_check_type")
public class PhcPhysicalCheckType implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 体检ID
     */
    @Column(name = "check_id")
    private Long checkId;

    /**
     * 体检类型(1上岗 2在岗 3离岗时 4复查 5应急 6离岗后)
     */
    @Column(name = "check_type")
    private Byte checkType;
    
    @Transient
    private String checkTypeName;

    /**
     * 应检人数
     */
    @Column(name = "need_check_total")
    private Integer needCheckTotal;
    
    /**
     * 职业健康检查报告存放位置
     */
    @Column(name = "report_location")
    private String reportLocation;
    
    /**
     * 职业健康检查报告存放位置
     */
    @Column(name = "staff_report_location")
    private String staffReportLocation;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;
    
    /**
     * 体检项目
     */
    @Column(name = "check_projects")
    private String checkProjects;

    @Transient
    private String[] checkReportFileArray;

    /**
     * 职业健康检查报告
     */
    @Column(name = "check_report_file_ids")
    private String checkReportFileIds;

    @Transient
    private List<SysFileModel> checkReportFiles;

    /**
     * 其他附件
     */
    @Column(name = "other_file_ids")
    private String otherFileIds;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取体检ID
     *
     * @return check_id - 体检ID
     */
    public Long getCheckId() {
        return checkId;
    }

    /**
     * 设置体检ID
     *
     * @param checkId 体检ID
     */
    public void setCheckId(Long checkId) {
        this.checkId = checkId;
    }

    /**
     * 获取体检类型(1上岗 2在岗 3离岗时 4复查 5应急 6离岗后)
     *
     * @return check_type - 体检类型(1上岗 2在岗 3离岗时 4复查 5应急 6离岗后)
     */
    public Byte getCheckType() {
        return checkType;
    }

    /**
     * 设置体检类型(1上岗 2在岗 3离岗时 4复查 5应急 6离岗后)
     *
     * @param checkType 体检类型(1上岗 2在岗 3离岗时 4复查 5应急 6离岗后)
     */
    public void setCheckType(Byte checkType) {
        this.checkType = checkType;
    }

    /**
     * 获取应检人数
     *
     * @return need_check_total - 应检人数
     */
    public Integer getNeedCheckTotal() {
        return needCheckTotal;
    }

    /**
     * 设置应检人数
     *
     * @param needCheckTotal 应检人数
     */
    public void setNeedCheckTotal(Integer needCheckTotal) {
        this.needCheckTotal = needCheckTotal;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public String getCheckTypeName() {
		if(this.checkType!=null) this.checkTypeName = CheckTypeEnum.getName(String.valueOf(this.checkType));
		return checkTypeName;
	}

	public void setCheckTypeName(String checkTypeName) {
		this.checkTypeName = checkTypeName;
	}

	public String getReportLocation() {
		return reportLocation;
	}

	public void setReportLocation(String reportLocation) {
		this.reportLocation = reportLocation;
	}

	public String getStaffReportLocation() {
		return staffReportLocation;
	}

	public void setStaffReportLocation(String staffReportLocation) {
		this.staffReportLocation = staffReportLocation;
	}

	public String getCheckProjects() {
		return checkProjects;
	}

	public void setCheckProjects(String checkProjects) {
		this.checkProjects = checkProjects;
	}

    public String[] getCheckReportFileArray() {
        return checkReportFileArray;
    }

    public void setCheckReportFileArray(String[] checkReportFileArray) {
        this.checkReportFileArray = checkReportFileArray;
    }

    public String getCheckReportFileIds() {
        return checkReportFileIds;
    }

    public void setCheckReportFileIds(String checkReportFileIds) {
        this.checkReportFileIds = checkReportFileIds;
    }

    public Boolean getValid() {
        return isValid;
    }

    public void setValid(Boolean valid) {
        isValid = valid;
    }

    public String getOtherFileIds() {
        return otherFileIds;
    }

    public void setOtherFileIds(String otherFileIds) {
        this.otherFileIds = otherFileIds;
    }

    public List<SysFileModel> getCheckReportFiles() {
        return checkReportFiles;
    }

    public void setCheckReportFiles(List<SysFileModel> checkReportFiles) {
        this.checkReportFiles = checkReportFiles;
    }
}