package cn.smarthse.modules.health.entity.work.check;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "phc_physical_check_third_info")
public class PhcPhysicalCheckThirdInfo implements Serializable {
    @Id
    private Long id;

    @Column(name = "check_id")
    private Long checkId;

    /**
     * 联系人
     */
    private String contactor;

    /**
     * 联系人电话
     */
    @Column(name = "contactor_tel")
    private String contactorTel;

    /**
     * 单位区域id
     */
    @Column(name = "company_area_id")
    private Long companyAreaId;

    /**
     * 单位地址详情
     */
    @Column(name = "company_address")
    private String companyAddress;

    /**
     * 体检地址
     */
    @Column(name = "check_address")
    private String checkAddress;

    /**
     * 是否复查
     */
    @Column(name = "is_recheck")
    private Boolean isRecheck;

    /**
     * 上报时间
     */
    @Column(name = "report_time")
    private Date reportTime;

    @Column(name = "third_org_id")
    private Long thirdOrgId;

    @Column(name = "third_org_name")
    private String thirdOrgName;

    @Column(name = "company_name")
    private String companyName;

    @Transient
    private Byte state;

    private static final long serialVersionUID = 1L;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    public Byte getState() {
        return state;
    }

    public void setState(Byte state) {
        this.state = state;
    }

    /**
     * @return check_id
     */
    public Long getCheckId() {
        return checkId;
    }

    /**
     * @param checkId
     */
    public void setCheckId(Long checkId) {
        this.checkId = checkId;
    }

    /**
     * 获取联系人
     *
     * @return contactor - 联系人
     */
    public String getContactor() {
        return contactor;
    }

    /**
     * 设置联系人
     *
     * @param contactor 联系人
     */
    public void setContactor(String contactor) {
        this.contactor = contactor == null ? null : contactor.trim();
    }

    /**
     * 获取联系人电话
     *
     * @return contactor_tel - 联系人电话
     */
    public String getContactorTel() {
        return contactorTel;
    }

    /**
     * 设置联系人电话
     *
     * @param contactorTel 联系人电话
     */
    public void setContactorTel(String contactorTel) {
        this.contactorTel = contactorTel == null ? null : contactorTel.trim();
    }

    /**
     * 获取单位区域id
     *
     * @return company_area_id - 单位区域id
     */
    public Long getCompanyAreaId() {
        return companyAreaId;
    }

    /**
     * 设置单位区域id
     *
     * @param companyAreaId 单位区域id
     */
    public void setCompanyAreaId(Long companyAreaId) {
        this.companyAreaId = companyAreaId;
    }

    /**
     * 获取单位地址详情
     *
     * @return company_address - 单位地址详情
     */
    public String getCompanyAddress() {
        return companyAddress;
    }

    /**
     * 设置单位地址详情
     *
     * @param companyAddress 单位地址详情
     */
    public void setCompanyAddress(String companyAddress) {
        this.companyAddress = companyAddress == null ? null : companyAddress.trim();
    }

    /**
     * 获取体检地址
     *
     * @return check_address - 体检地址
     */
    public String getCheckAddress() {
        return checkAddress;
    }

    /**
     * 设置体检地址
     *
     * @param checkAddress 体检地址
     */
    public void setCheckAddress(String checkAddress) {
        this.checkAddress = checkAddress == null ? null : checkAddress.trim();
    }

    /**
     * 获取是否复查
     *
     * @return is_recheck - 是否复查
     */
    public Boolean getIsRecheck() {
        return isRecheck;
    }

    /**
     * 设置是否复查
     *
     * @param isRecheck 是否复查
     */
    public void setIsRecheck(Boolean isRecheck) {
        this.isRecheck = isRecheck;
    }

    /**
     * 获取上报时间
     *
     * @return report_time - 上报时间
     */
    public Date getReportTime() {
        return reportTime;
    }

    /**
     * 设置上报时间
     *
     * @param reportTime 上报时间
     */
    public void setReportTime(Date reportTime) {
        this.reportTime = reportTime;
    }

    /**
     * @return third_org_id
     */
    public Long getThirdOrgId() {
        return thirdOrgId;
    }

    /**
     * @param thirdOrgId
     */
    public void setThirdOrgId(Long thirdOrgId) {
        this.thirdOrgId = thirdOrgId;
    }

    /**
     * @return third_org_name
     */
    public String getThirdOrgName() {
        return thirdOrgName;
    }

    /**
     * @param thirdOrgName
     */
    public void setThirdOrgName(String thirdOrgName) {
        this.thirdOrgName = thirdOrgName == null ? null : thirdOrgName.trim();
    }

    /**
     * @return company_name
     */
    public String getCompanyName() {
        return companyName;
    }

    /**
     * @param companyName
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName == null ? null : companyName.trim();
    }
}