package cn.smarthse.modules.health.entity.work.check;

import cn.smarthse.modules.health.enums.check.WorkStateEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "phc_physical_check_recommend_query")
public @Data class PhcPhysicalCheckRecommendQuery implements Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;
    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 接害岗位
     */
    @Column(name = "work_id")
    private Long workId;

    @Transient
    private String workName;
    /**
     * 岗位状态:1、上岗前，2、在岗，4、离岗时
     */
    @Column(name = "work_state")
    private Byte workState;

    @Transient
    private String workStateName;

    /**
     * 特殊作业（逗号隔开）
     */
    @Column(name = "special_works")
    private String specialWorks;

    /**
     * 经过的工作场所（逗号隔开）
     */
    @Column(name = "harm_area_names")
    private String harmAreaNames;

    @Transient
    private String[] specialWorkIds;

    /**
     * 危害因素（逗号隔开）
     */
    private String harms;

    @Transient
    private String[] harmIds;

    /**
     * 体检必检项目（逗号隔开）
     */
    @Column(name = "must_checks")
    private String mustChecks;

    /**
     * 体检选检项目（逗号隔开）
     */
    @Column(name = "choose_checks")
    private String chooseChecks;

    /**
     * 导出状态:0、未导出，1、已导出
     */
    @Column(name = "export_state")
    private Byte exportState;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    public String getWorkStateName() {
        workStateName = WorkStateEnum.getName(this.workState);
        return workStateName;
    }

}