package cn.smarthse.modules.health.entity.work.check;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "phc_physical_check_recommend_ignored")
public class PhcPhysicalCheckRecommendIgnored implements Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 忽略的员工
     */
    @Column(name = "staff_id")
    private Long staffId;

    /**
     * 忽略的员工的岗位
     */
    @Column(name = "work_id")
    private Long workId;

    /**
     * 体检类型
     */
    @Column(name = "check_type")
    private Byte checkType;

    /**
     * 忽略时间
     */
    @Column(name = "ignore_date")
    private Date ignoreDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取忽略的员工
     *
     * @return staff_id - 忽略的员工
     */
    public Long getStaffId() {
        return staffId;
    }

    /**
     * 设置忽略的员工
     *
     * @param staffId 忽略的员工
     */
    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    /**
     * 获取忽略的员工的岗位
     *
     * @return work_id - 忽略的员工的岗位
     */
    public Long getWorkId() {
        return workId;
    }

    /**
     * 设置忽略的员工的岗位
     *
     * @param workId 忽略的员工的岗位
     */
    public void setWorkId(Long workId) {
        this.workId = workId;
    }

    /**
     * 获取体检类型
     *
     * @return check_type - 体检类型
     */
    public Byte getCheckType() {
        return checkType;
    }

    /**
     * 设置体检类型
     *
     * @param checkType 体检类型
     */
    public void setCheckType(Byte checkType) {
        this.checkType = checkType;
    }

    /**
     * 获取忽略时间
     *
     * @return ignore_date - 忽略时间
     */
    public Date getIgnoreDate() {
        return ignoreDate;
    }

    /**
     * 设置忽略时间
     *
     * @param ignoreDate 忽略时间
     */
    public void setIgnoreDate(Date ignoreDate) {
        this.ignoreDate = ignoreDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }
}