package cn.smarthse.modules.health.entity.work.check;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "phc_physical_check_data_result")
public class PhcPhysicalCheckDataResult implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 体检数据id
     */
    @Column(name = "data_id")
    private Long dataId;

    /**
     * 体检结果(1、正常 2、复查 3、疑似职业病 4、职业禁忌症 5、其他疾病或异常)
     */
    @Column(name = "exam_result")
    private Byte examResult;

    /**
     * 危害因素
     */
    @Column(name = "harm_factor")
    private String harmFactor;

    /**
     * 复查项目
     */
    @Column(name = "re_check")
    private String reCheck;

    /**
     * 疾病名称或异常描述
     */
    @Column(name = "harm_desc")
    private String harmDesc;

    /**
     * 接害工龄
     */
    @Column(name = "harm_year")
    private String harmYear;

    /**
     * 体检建议
     */
    @Column(name = "check_advice")
    private String checkAdvice;
    
    /**
     * 异常指标
     */
    private String abnormal;

    /**
     * 处理措施(1复查 2转岗 3职业病诊断 4不录用 5其他)
     */
    @Column(name = "deal_type")
    private Byte dealType;

    /**
     * 情况说明
     */
    @Column(name = "info_desc")
    private String infoDesc;

    /**
     * 现场处理情况
     */
    @Column(name = "deal_desc")
    private String dealDesc;

    /**
     * 处理状态（0未完成 1已完成）
     */
    @Column(name = "deal_status")
    private Byte dealStatus;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 医学建议
     */
    @Column(name = "medical_advice")
    private String medicalAdvice;

    /**
     * 缺必检项
     */
    @Column(name = "missing_items")
    private String missingItems;

    @Column(name = "occ_id")
    private String occId;
    
    @Transient
    private Byte checkType;

    /**************v2.10.5新增************/
    @Transient
    private String updator;
    @Column(name = "exchange_report_ids")
    private String exchangeReportIds;
    @Column(name = "begin_time")
    private Date beginTime;
    @Column(name = "end_time")
    private Date endTime;
    @Column(name = "third_org_id")
    private Long thirdOrgId;
    @Column(name = "third_org_report_id")
    private Long thirdOrgReportId;
    @Column(name = "deal_time")
    private Date dealTime;
    @Column(name = "third_org_report_time")
    private Date thirdOrgReportTime;
    @Column(name = "supervise_deal_status")
    private Byte superviseDealStatus;

    @Column(name = "confirmation")
    private Byte confirmation;

    @Column(name = "sign")
    private String sign;

    @Column(name = "report_files")
    private String reportFiles;


    @Transient
    private String thirdOrgName;
    @Transient
    private String recheckBatchIds;
    @Transient
    private String staffName;

    @Transient
    private String idCard;
    @Transient
    private String workName;

    @Transient
    private String deptName;

    @Transient
    private String harmNames;
    @Transient
    private String occHarmNames;

    @Transient
    private Date checkTime;
    private static final long serialVersionUID = 1L;

    /*3.1.1新增*/

    /**
     * 监管端状态（0：未处理，1：企业端已上报（企业整改上报时改为该状态），2：已忽略，3：已确认
     */
    @Column(name = "supervise_status")
    private Integer superviseStatus;

    /**
     * 数据来源（1 万达仓)
     */
    @Column(name = "data_source")
    private Byte dataSource;

    //sql里面有该字段但是在该实体类里面没有
    @Transient
    private Long  harmDescId;

    public Long getHarmDescId() {
        return harmDescId;
    }

    public void setHarmDescId(Long harmDescId) {
        this.harmDescId = harmDescId;
    }

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取体检数据id
     *
     * @return data_id - 体检数据id
     */
    public Long getDataId() {
        return dataId;
    }

    /**
     * 设置体检数据id
     *
     * @param dataId 体检数据id
     */
    public void setDataId(Long dataId) {
        this.dataId = dataId;
    }

    /**
     * 获取体检结果(1、正常 2、复查 3、疑似职业病 4、职业禁忌症 5、其他疾病或异常)
     *
     * @return exam_result - 体检结果(1、正常 2、复查 3、疑似职业病 4、职业禁忌症 5、其他疾病或异常)
     */
    public Byte getExamResult() {
        return examResult;
    }

    /**
     * 设置体检结果(1、正常 2、复查 3、疑似职业病 4、职业禁忌症 5、其他疾病或异常)
     *
     * @param examResult 体检结果(1、正常 2、复查 3、疑似职业病 4、职业禁忌症 5、其他疾病或异常)
     */
    public void setExamResult(Byte examResult) {
        this.examResult = examResult;
    }

    /**
     * 获取危害因素
     *
     * @return harm_factor - 危害因素
     */
    public String getHarmFactor() {
        return harmFactor;
    }

    /**
     * 设置危害因素
     *
     * @param harmFactor 危害因素
     */
    public void setHarmFactor(String harmFactor) {
        this.harmFactor = harmFactor;
    }

    /**
     * 获取复查项目
     *
     * @return re_check - 复查项目
     */
    public String getReCheck() {
        return reCheck;
    }

    /**
     * 设置复查项目
     *
     * @param reCheck 复查项目
     */
    public void setReCheck(String reCheck) {
        this.reCheck = reCheck == null ? null : reCheck.trim();
    }

    /**
     * 获取疾病名称或异常描述
     *
     * @return harm_desc - 疾病名称或异常描述
     */
    public String getHarmDesc() {
        return harmDesc;
    }

    /**
     * 设置疾病名称或异常描述
     *
     * @param harmDesc 疾病名称或异常描述
     */
    public void setHarmDesc(String harmDesc) {
        this.harmDesc = harmDesc == null ? null : harmDesc.trim();
    }

    /**
     * 获取接害工龄
     *
     * @return harm_year - 接害工龄
     */
    public String getHarmYear() {
        return harmYear;
    }

    /**
     * 设置接害工龄
     *
     * @param harmYear 接害工龄
     */
    public void setHarmYear(String harmYear) {
        this.harmYear = harmYear == null ? null : harmYear.trim();
    }

    /**
     * 获取体检建议
     *
     * @return check_advice - 体检建议
     */
    public String getCheckAdvice() {
        return checkAdvice;
    }

    /**
     * 设置体检建议
     *
     * @param checkAdvice 体检建议
     */
    public void setCheckAdvice(String checkAdvice) {
        this.checkAdvice = checkAdvice == null ? null : checkAdvice.trim();
    }

    /**
     * 获取处理措施(1复查 2转岗 3职业病诊断 4不录用 5其他)
     *
     * @return deal_type - 处理措施(1复查 2转岗 3职业病诊断 4不录用 5其他)
     */
    public Byte getDealType() {
        return dealType;
    }

    /**
     * 设置处理措施(1复查 2转岗 3职业病诊断 4不录用 5其他)
     *
     * @param dealType 处理措施(1复查 2转岗 3职业病诊断 4不录用 5其他)
     */
    public void setDealType(Byte dealType) {
        this.dealType = dealType;
    }

    /**
     * 获取情况说明
     *
     * @return info_desc - 情况说明
     */
    public String getInfoDesc() {
        return infoDesc;
    }

    /**
     * 设置情况说明
     *
     * @param infoDesc 情况说明
     */
    public void setInfoDesc(String infoDesc) {
        this.infoDesc = infoDesc == null ? null : infoDesc.trim();
    }

    /**
     * 获取现场处理情况
     *
     * @return deal_desc - 现场处理情况
     */
    public String getDealDesc() {
        return dealDesc;
    }

    /**
     * 设置现场处理情况
     *
     * @param dealDesc 现场处理情况
     */
    public void setDealDesc(String dealDesc) {
        this.dealDesc = dealDesc == null ? null : dealDesc.trim();
    }

    /**
     * 获取处理状态（0未完成 1已完成）
     *
     * @return deal_status - 处理状态（0未完成 1已完成）
     */
    public Byte getDealStatus() {
        return dealStatus;
    }

    /**
     * 设置处理状态（0未完成 1已完成）
     *
     * @param dealStatus 处理状态（0未完成 1已完成）
     */
    public void setDealStatus(Byte dealStatus) {
        this.dealStatus = dealStatus;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public String getAbnormal() {
		return abnormal;
	}

	public void setAbnormal(String abnormal) {
		this.abnormal = abnormal;
	}

	public Byte getCheckType() {
		return checkType;
	}

	public void setCheckType(Byte checkType) {
		this.checkType = checkType;
	}

    public String getMedicalAdvice() {
        return medicalAdvice;
    }

    public void setMedicalAdvice(String medicalAdvice) {
        this.medicalAdvice = medicalAdvice;
    }

    public String getMissingItems() {
        return missingItems;
    }

    public void setMissingItems(String missingItems) {
        this.missingItems = missingItems;
    }

    public String getUpdator() {
        return updator;
    }

    public void setUpdator(String updator) {
        this.updator = updator;
    }

    public String getExchangeReportIds() {
        return exchangeReportIds;
    }

    public void setExchangeReportIds(String exchangeReportIds) {
        this.exchangeReportIds = exchangeReportIds;
    }

    public Date getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Long getThirdOrgId() {
        return thirdOrgId;
    }

    public void setThirdOrgId(Long thirdOrgId) {
        this.thirdOrgId = thirdOrgId;
    }

    public Date getDealTime() {
        return dealTime;
    }

    public void setDealTime(Date dealTime) {
        this.dealTime = dealTime;
    }

    public Date getThirdOrgReportTime() {
        return thirdOrgReportTime;
    }

    public void setThirdOrgReportTime(Date thirdOrgReportTime) {
        this.thirdOrgReportTime = thirdOrgReportTime;
    }

    public Byte getSuperviseDealStatus() {
        return superviseDealStatus;
    }

    public void setSuperviseDealStatus(Byte superviseDealStatus) {
        this.superviseDealStatus = superviseDealStatus;
    }

    public String getThirdOrgName() {
        return thirdOrgName;
    }

    public void setThirdOrgName(String thirdOrgName) {
        this.thirdOrgName = thirdOrgName;
    }

    public Long getThirdOrgReportId() {
        return thirdOrgReportId;
    }

    public void setThirdOrgReportId(Long thirdOrgReportId) {
        this.thirdOrgReportId = thirdOrgReportId;
    }

    public String getRecheckBatchIds() {
        return recheckBatchIds;
    }

    public void setRecheckBatchIds(String recheckBatchIds) {
        this.recheckBatchIds = recheckBatchIds;
    }

    public String getStaffName() {
        return staffName;
    }

    public void setStaffName(String staffName) {
        this.staffName = staffName;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public String getWorkName() {
        return workName;
    }

    public void setWorkName(String workName) {
        this.workName = workName;
    }

    public String getHarmNames() {
        return harmNames;
    }

    public void setHarmNames(String harmNames) {
        this.harmNames = harmNames;
    }

    public String getOccHarmNames() {
        return occHarmNames;
    }

    public void setOccHarmNames(String occHarmNames) {
        this.occHarmNames = occHarmNames;
    }

    public Byte getConfirmation() {
        return confirmation;
    }

    public void setConfirmation(Byte confirmation) {
        this.confirmation = confirmation;
    }

    public String getOccId() {
        return occId;
    }

    public void setOccId(String occId) {
        this.occId = occId;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getReportFiles() {
        return reportFiles;
    }

    public void setReportFiles(String reportFiles) {
        this.reportFiles = reportFiles;
    }

    public Integer getSuperviseStatus() {
        return superviseStatus;
    }

    public void setSuperviseStatus(Integer superviseStatus) {
        this.superviseStatus = superviseStatus;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public Date getCheckTime() {
        return checkTime;
    }

    public void setCheckTime(Date checkTime) {
        this.checkTime = checkTime;
    }

    public Byte getDataSource() {
        return dataSource;
    }

    public void setDataSource(Byte dataSource) {
        this.dataSource = dataSource;
    }
}