package cn.smarthse.modules.health.entity.work.check;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

@Table(name = "phc_physical_check_data")
public class PhcPhysicalCheckData implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 体检ID
     */
    @Column(name = "check_id")
    private Long checkId;

    /**
     * 员工ID
     */
    @Column(name = "staff_Id")
    private Long staffId;
    
    @Transient
    private String idCard;
    
    /**
     * 员工体检时姓名
     */
    @Column(name = "staff_name")
    private String staffName;
    
    @Column(name = "staff_work_no")
    private String staffWorkNo;

    /**
     * 体检时部门
     */
    @Column(name = "staff_dept_id")
    private Long staffDeptId;
    
    /**
     * 员工体检时部门名称
     */
    @Column(name = "staff_dept_name")
    private String staffDeptName;

    /**
     * 体检时岗位
     */
    @Column(name = "staff_work_id")
    private Long staffWorkId;
    
    /**
     * 员工体检时岗位名称
     */
    @Column(name = "staff_work_name")
    private String staffWorkName;

    /**
     * 体检种类
     */
    @Column(name = "check_type")
    private Byte checkType;

    /**
     * 是否已参加(0未参加 1已参加)
     */
    @Column(name = "is_join")
    private Boolean isJoin;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 数据来源（1 万达仓)
     */
    @Column(name = "data_source")
    private Byte dataSource;

    private static final long serialVersionUID = 1L;

    @Transient
    private List<PhcPhysicalCheckDataResult> results = new ArrayList<PhcPhysicalCheckDataResult>();

    /**
     * 体检结果(1、正常 2、复查 3、疑似职业病 4、职业禁忌症 5、其他疾病或异常)
     */
    @Transient
    private Byte examResult;

    /**
     * 个人体检报告
     */
    @Transient
    private String[] resultReportFileIdArr;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取体检ID
     *
     * @return check_id - 体检ID
     */
    public Long getCheckId() {
        return checkId;
    }

    /**
     * 设置体检ID
     *
     * @param checkId 体检ID
     */
    public void setCheckId(Long checkId) {
        this.checkId = checkId;
    }

    /**
     * 获取员工ID
     *
     * @return staff_Id - 员工ID
     */
    public Long getStaffId() {
        return staffId;
    }

    /**
     * 设置员工ID
     *
     * @param staffId 员工ID
     */
    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    /**
     * 获取体检时部门
     *
     * @return staff_dept_id - 体检时部门
     */
    public Long getStaffDeptId() {
        return staffDeptId;
    }

    /**
     * 设置体检时部门
     *
     * @param staffDeptId 体检时部门
     */
    public void setStaffDeptId(Long staffDeptId) {
        this.staffDeptId = staffDeptId;
    }

    /**
     * 获取体检时岗位
     *
     * @return staff_work_id - 体检时岗位
     */
    public Long getStaffWorkId() {
        return staffWorkId;
    }

    /**
     * 设置体检时岗位
     *
     * @param staffWorkId 体检时岗位
     */
    public void setStaffWorkId(Long staffWorkId) {
        this.staffWorkId = staffWorkId;
    }

    /**
     * 获取体检种类
     *
     * @return check_type - 体检种类
     */
    public Byte getCheckType() {
        return checkType;
    }

    /**
     * 设置体检种类
     *
     * @param checkType 体检种类
     */
    public void setCheckType(Byte checkType) {
        this.checkType = checkType;
    }

    /**
     * 获取是否已参加(0未参加 1已参加)
     *
     * @return is_join - 是否已参加(0未参加 1已参加)
     */
    public Boolean getIsJoin() {
        return isJoin;
    }

    /**
     * 设置是否已参加(0未参加 1已参加)
     *
     * @param isJoin 是否已参加(0未参加 1已参加)
     */
    public void setIsJoin(Boolean isJoin) {
        this.isJoin = isJoin;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public String getStaffName() {
		return staffName;
	}

	public void setStaffName(String staffName) {
		this.staffName = staffName;
	}

	public String getStaffWorkNo() {
		return staffWorkNo;
	}

	public void setStaffWorkNo(String staffWorkNo) {
		this.staffWorkNo = staffWorkNo;
	}

	public String getStaffDeptName() {
		return staffDeptName;
	}

	public void setStaffDeptName(String staffDeptName) {
		this.staffDeptName = staffDeptName;
	}

	public String getStaffWorkName() {
		return staffWorkName;
	}

	public void setStaffWorkName(String staffWorkName) {
		this.staffWorkName = staffWorkName;
	}

	public List<PhcPhysicalCheckDataResult> getResults() {
		return results;
	}

	public void setResults(List<PhcPhysicalCheckDataResult> results) {
		this.results = results;
	}

	public Byte getExamResult() {
		return examResult;
	}

	public void setExamResult(Byte examResult) {
        this.examResult = examResult;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public String[] getResultReportFileIdArr() {
        return resultReportFileIdArr;
    }

    public void setResultReportFileIdArr(String[] resultReportFileIdArr) {
        this.resultReportFileIdArr = resultReportFileIdArr;
    }

    public Byte getDataSource() {
        return dataSource;
    }

    public void setDataSource(Byte dataSource) {
        this.dataSource = dataSource;
    }
}