package cn.smarthse.modules.health.entity.work.check;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "phc_physical_check_count")
public @Data
class PhcPhysicalCheckCount implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业id
     */
    private Long cid;



    /**
     * 体检id
     */
    @Column(name = "check_id")
    private Long checkId;

    /**
     * 体检开始时间
     */
    @Column(name = "check_begin_time")
    private Date checkBeginTime;

    /**
     * 体检结束时间
     */
    @Column(name = "check_end_time")
    private Date checkEndTime;
    /**
     * 体检企业数
     */
    @Column(name = "checked")
    private Integer checked;
    /**
     * 接害人总数
     */
    @Column(name = "harm")
    private Integer harm;


    /**
     * 接触危害因素人总数
     */
    @Column(name = "check_total")
    private Integer checkTotal;

    /**
     * 接触粉尘人数
     */
    private Integer dust;

    /**
     * 接触化学因素人数
     */
    private Integer chemistry;

    /**
     * 接触物理因素人数
     */
    private Integer physical;

    /**
     * 接触放射因素人数
     */
    private Integer radiation;

    /**
     * 职业禁忌证人数
     */
    private Integer oc;
    /**
     * 疑似职业病人总数
     */
    private Integer suspected;

    /**
     * 确诊职业病人总数
     */
    private Integer sure;
    /**
     * 体检名称
     */
    @Column(name = "work_name")
    private String workName ;
    /**
     * 体检类型
     */
    @Column(name = "check_types")
    private String checkTypes;
    /**
     * 机构id
     */
    @Column(name = "org_id")
    private Long orgId;
    /**
     * 机构id
     */
    @Column(name = "org_name")
    private String orgName;

    /**
     * 上报时间
     */
    @Column(name = "report_time")
    private Date reportTime;
    /**
     * 状态
     */
    @Column(name = "report_state")
    private Integer reportState;



    private static final long serialVersionUID = 1L;


}