package cn.smarthse.modules.health.entity.work.check;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

@Table(name = "phc_physical_check_company_count")
public class PhcPhysicalCheckCompanyCount implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业id
     */
    private Long cid;

    /**
     * 企业名称
     */
    private String name;

    /**
     * 行政区域区编号(SYS_area.id)
     */
    @Column(name = "area_id")
    private Long areaId;

    /**
     * 注册类型
     */
    @Column(name = "register_type")
    private Long registerType;

    /**
     * 行业分类（sys_param.param_code）
     */
    @Column(name = "industry_category")
    private Long industryCategory;

    /**
     * 职业病危害风险分类(0-严重、1-较重、2-一般)
     */
    @Column(name = "occupational_risk_classify")
    private Byte occupationalRiskClassify;

    /**
     * 企业规模
     */
    private String scale;

    /**
     * 接害人总数
     */
    private Integer harm;

    /**
     * 疑似职业病人总数
     */
    private Integer suspected;

    /**
     * 确诊职业病人总数
     */
    private Integer sure;

    /**
     * 检测企业数
     */
    private Integer checked;

    /**
     * 申报企业数
     */
    private Integer declared;

    /**
     * 职业禁忌证人数
     */
    private Integer oc;

    /**
     * 已体检企业数
     */
    private Integer examedCompany;

    /**
     * 接触粉尘人数
     */
    private Integer dust;

    /**
     * 接触化学因素人数
     */
    private Integer chemistry;

    /**
     * 接触物理因素人数
     */
    private Integer physical;

    /**
     * 接触放射因素人数
     */
    private Integer radiation;

    /**
     * 接触危害因素人总数
     */
    private Integer riskTotal;

    /**
     *接害人总数+疑似/确诊职业病人总数+接触危害因素总数+职业禁忌症总数
    */
    private Integer allTotal;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    private static final long serialVersionUID = 1L;

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业id
     *
     * @return cid - 企业id
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业id
     *
     * @param cid 企业id
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取企业名称
     *
     * @return name - 企业名称
     */
    public String getName() {
        return name;
    }

    /**
     * 设置企业名称
     *
     * @param name 企业名称
     */
    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    /**
     * 获取行政区域区编号(SYS_area.id)
     *
     * @return area_id - 行政区域区编号(SYS_area.id)
     */
    public Long getAreaId() {
        return areaId;
    }

    /**
     * 设置行政区域区编号(SYS_area.id)
     *
     * @param areaId 行政区域区编号(SYS_area.id)
     */
    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    /**
     * 获取注册类型
     *
     * @return register_type - 注册类型
     */
    public Long getRegisterType() {
        return registerType;
    }

    /**
     * 设置注册类型
     *
     * @param registerType 注册类型
     */
    public void setRegisterType(Long registerType) {
        this.registerType = registerType;
    }

    /**
     * 获取行业分类（sys_param.param_code）
     *
     * @return industry_category - 行业分类（sys_param.param_code）
     */
    public Long getIndustryCategory() {
        return industryCategory;
    }

    /**
     * 设置行业分类（sys_param.param_code）
     *
     * @param industryCategory 行业分类（sys_param.param_code）
     */
    public void setIndustryCategory(Long industryCategory) {
        this.industryCategory = industryCategory;
    }

    /**
     * 获取职业病危害风险分类(0-严重、1-较重、2-一般)
     *
     * @return occupational_risk_classify - 职业病危害风险分类(0-严重、1-较重、2-一般)
     */
    public Byte getOccupationalRiskClassify() {
        return occupationalRiskClassify;
    }

    /**
     * 设置职业病危害风险分类(0-严重、1-较重、2-一般)
     *
     * @param occupationalRiskClassify 职业病危害风险分类(0-严重、1-较重、2-一般)
     */
    public void setOccupationalRiskClassify(Byte occupationalRiskClassify) {
        this.occupationalRiskClassify = occupationalRiskClassify;
    }

    /**
     * 获取企业规模
     *
     * @return scale - 企业规模
     */
    public String getScale() {
        return scale;
    }

    /**
     * 设置企业规模
     *
     * @param scale 企业规模
     */
    public void setScale(String scale) {
        this.scale = scale == null ? null : scale.trim();
    }

    /**
     * 获取接害人总数
     *
     * @return harm - 接害人总数
     */
    public Integer getHarm() {
        return harm;
    }

    /**
     * 设置接害人总数
     *
     * @param harm 接害人总数
     */
    public void setHarm(Integer harm) {
        this.harm = harm;
    }

    /**
     * 获取疑似职业病人总数
     *
     * @return suspected - 疑似职业病人总数
     */
    public Integer getSuspected() {
        return suspected;
    }

    /**
     * 设置疑似职业病人总数
     *
     * @param suspected 疑似职业病人总数
     */
    public void setSuspected(Integer suspected) {
        this.suspected = suspected;
    }

    /**
     * 获取确诊职业病人总数
     *
     * @return sure - 确诊职业病人总数
     */
    public Integer getSure() {
        return sure;
    }

    /**
     * 设置确诊职业病人总数
     *
     * @param sure 确诊职业病人总数
     */
    public void setSure(Integer sure) {
        this.sure = sure;
    }

    /**
     * 获取检测企业数
     *
     * @return checked - 检测企业数
     */
    public Integer getChecked() {
        return checked;
    }

    /**
     * 设置检测企业数
     *
     * @param checked 检测企业数
     */
    public void setChecked(Integer checked) {
        this.checked = checked;
    }

    /**
     * 获取申报企业数
     *
     * @return declared - 申报企业数
     */
    public Integer getDeclared() {
        return declared;
    }

    /**
     * 设置申报企业数
     *
     * @param declared 申报企业数
     */
    public void setDeclared(Integer declared) {
        this.declared = declared;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public Integer getOc() {
        return oc;
    }

    public void setOc(Integer oc) {
        this.oc = oc;
    }

    public Integer getExamedCompany() {
        return examedCompany;
    }

    public void setExamedCompany(Integer examedCompany) {
        this.examedCompany = examedCompany;
    }

    public Integer getDust() {
        return dust;
    }

    public void setDust(Integer dust) {
        this.dust = dust;
    }

    public Integer getChemistry() {
        return chemistry;
    }

    public void setChemistry(Integer chemistry) {
        this.chemistry = chemistry;
    }

    public Integer getPhysical() {
        return physical;
    }

    public void setPhysical(Integer physical) {
        this.physical = physical;
    }

    public Integer getRadiation() {
        return radiation;
    }

    public void setRadiation(Integer radiation) {
        this.radiation = radiation;
    }

    public Integer getRiskTotal() {
        return riskTotal;
    }

    public void setRiskTotal(Integer riskTotal) {
        this.riskTotal = riskTotal;
    }

    public Integer getAllTotal() {
        return allTotal;
    }

    public void setAllTotal(Integer allTotal) {
        this.allTotal = allTotal;
    }
}