package cn.smarthse.modules.health.entity.work.check;

import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.modules.health.entity.work.check.vo.count.CheckTypeCount;
import cn.smarthse.modules.health.enums.sys.SimpleStatusEnum;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import javax.persistence.*;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@JsonIgnoreProperties(value = {"handler"})
@Table(name = "phc_physical_check")
public class PhcPhysicalCheck implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 体检编号
     */
    private String no;

    /**
     * 工作名称
     */
    @Column(name = "work_name")
    private String workName;

    /**
     * 开始时间
     */
    @Column(name = "begin_time")
    private Date beginTime;

    /**
     * 结束时间
     */
    @Column(name = "end_time")
    private Date endTime;

    /**
     * 负责人
     */
    private Long manager;

    /**
     * 体检机构
     */
    private Long hospital; 

    /**
     * 检查报告存放位置
     */
    @Column(name = "files_storage_location")
    private String filesStorageLocation;

    /**
     * 状态（0未完成 1已完成）
     */
    private Byte status;
    
    @Transient
    private String statusName;

    @Transient
    private Integer bodyCheckType;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否复查登记（0否 1是）
     */
    @Column(name = "is_recheck")
    private Boolean isRecheck;

    /**
     * 是否补检登记（0否 1是）
     */
    @Column(name = "is_replenish")
    private Boolean isReplenish;

    /**
     * 关键工作提醒来源对应CoreWorkEnum
     * */
    @Column(name = "from_type")
    private Byte fromType;
    @Column(name = "from_id")
    private Long fromId;
    /* 
    * @Comments:  <表里有该字段sql>
    * @author BinXu(徐斌) [784514607@qq.com]
    * @since 下午3:50 2021/10/8
    **/
    @Transient
    private String employerId;

    /**
     * 信息来源（1、企业端，2、服务机构）
     */
    @Column(name = "source")
    private Byte source;

    @Transient
    private String hospitalName;
    @Transient
    private String managerName;
    @Transient
    private List<PhcPhysicalCheckType> checkTypes;
    @Transient
    private List<PhcPhysicalCheckFile> reportFiles = new ArrayList<PhcPhysicalCheckFile>();     
    @Transient
    private String checkTime;
    @Transient
    private String checkDate;
    @Transient
    private String checkTypeNames;
    @Transient
    private List<PhcPhysicalCheckData> datas;
    @Transient
    private PhcPhysicalCheckThirdInfo thirdInfo;
    @Transient
    private String thirdOrgName;

    @Transient
    private String companyName;

    @Transient
    private Integer checkYear;
    @Transient
    private List<CheckTypeCount> checkTypeCounts;
    //未查看人数
    @Transient
    private Integer notViewNum;
    //已查看未确认人数
    @Transient
    private Integer unconfirmedNum;
    //已签字人数
    @Transient
    private Integer signedNum;
    //反馈内容
    @Transient
    private String feedBackContent;


    private static final long serialVersionUID = 1L;

    /**
     * 创建人对应的部门
     */
    @Column(name = "org_id")
    private String orgId;

    /**
     * 数据来源（1 万达仓)
     */
    @Column(name = "data_source")
    private Byte dataSource;

    public String getFeedBackContent() {
        return feedBackContent;
    }

    public void setFeedBackContent(String feedBackContent) {
        this.feedBackContent = feedBackContent;
    }

    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取体检编号
     *
     * @return no - 体检编号
     */
    public String getNo() {
        return no;
    }

    /**
     * 设置体检编号
     *
     * @param no 体检编号
     */
    public void setNo(String no) {
        this.no = no == null ? null : no.trim();
    }

    /**
     * 获取工作名称
     *
     * @return work_name - 工作名称
     */
    public String getWorkName() {
        return workName;
    }

    /**
     * 设置工作名称
     *
     * @param workName 工作名称
     */
    public void setWorkName(String workName) {
        this.workName = workName == null ? null : workName.trim();
    }

    /**
     * 获取开始时间
     *
     * @return begin_time - 开始时间
     */
    public Date getBeginTime() {
        return beginTime;
    }

    /**
     * 设置开始时间
     *
     * @param beginTime 开始时间
     */
    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    /**
     * 获取结束时间
     *
     * @return end_time - 结束时间
     */
    public Date getEndTime() {
        return endTime;
    }

    /**
     * 设置结束时间
     *
     * @param endTime 结束时间
     */
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    /**
     * 获取负责人
     *
     * @return manager - 负责人
     */
    public Long getManager() {
        return manager;
    }

    /**
     * 设置负责人
     *
     * @param manager 负责人
     */
    public void setManager(Long manager) {
        this.manager = manager;
    }

    /**
     * 获取体检机构
     *
     * @return hospital - 体检机构
     */
    public Long getHospital() {
        return hospital;
    }

    /**
     * 设置体检机构
     *
     * @param hospital 体检机构
     */
    public void setHospital(Long hospital) {
        this.hospital = hospital;
    }

    /**
     * 获取检查报告存放位置
     *
     * @return files_storage_location - 检查报告存放位置
     */
    public String getFilesStorageLocation() {
        return filesStorageLocation;
    }

    /**
     * 设置检查报告存放位置
     *
     * @param filesStorageLocation 检查报告存放位置
     */
    public void setFilesStorageLocation(String filesStorageLocation) {
        this.filesStorageLocation = filesStorageLocation == null ? null : filesStorageLocation.trim();
    }

    /**
     * 获取状态（0未完成 1已完成）
     *
     * @return status - 状态（0未完成 1已完成）
     */
    public Byte getStatus() {
        return status;
    }

    /**
     * 设置状态（0未完成 1已完成）
     *
     * @param status 状态（0未完成 1已完成）
     */
    public void setStatus(Byte status) {
        this.status = status;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取是否复查登记（0否 1是）
     *
     * @return is_recheck - 是否复查登记（0否 1是）
     */
    public Boolean getIsRecheck() {
        return isRecheck;
    }

    /**
     * 设置是否复查登记（0否 1是）
     *
     * @param isRecheck 是否复查登记（0否 1是）
     */
    public void setIsRecheck(Boolean isRecheck) {
        this.isRecheck = isRecheck;
    }

	public String getManagerName() {
		return managerName;
	}

	public void setManagerName(String managerName) {
		this.managerName = managerName;
	}

	public String getHospitalName() {
        return hospitalName;
	}

	public void setHospitalName(String hospitalName) {
		this.hospitalName = hospitalName;
	}

	public List<PhcPhysicalCheckType> getCheckTypes() {
		return checkTypes;
	}

	public void setCheckTypes(List<PhcPhysicalCheckType> checkTypes) {
		this.checkTypes = checkTypes;
	}

	public List<PhcPhysicalCheckFile> getReportFiles() {
		return reportFiles;
	}

	public void setReportFiles(List<PhcPhysicalCheckFile> reportFiles) {
		this.reportFiles = reportFiles;
	}

	public String getCheckTime() {
		if(this.beginTime==null||this.endTime==null) return checkTime;
		String pattern = "yyyy-MM-dd HH:mm:ss";
		checkTime = DateUtils.format(beginTime, pattern) + Constants.CHECK_TIME_SPLITOR + DateUtils.format(endTime, pattern);
		return checkTime;
	}

	public void setCheckTime(String checkTime) {
		this.checkTime = checkTime;
	}

	public String getCheckDate() {
		if(this.beginTime==null||this.endTime==null) return checkDate;
		String pattern = "yyyy-MM-dd";
		checkDate = DateUtils.format(beginTime, pattern) + Constants.CHECK_TIME_SPLITOR + DateUtils.format(endTime, pattern);
		return checkDate;
	}

	public void setCheckDate(String checkDate) {
		this.checkDate = checkDate;
	}

	public String getCheckTypeNames() {
		if(this.checkTypes==null) return checkTypeNames;
		String types = "";
		for(PhcPhysicalCheckType checkType:checkTypes) {
			types += checkType.getCheckTypeName() + " ";
		}
		checkTypeNames = types;
		return checkTypeNames;
	}

	public void setCheckTypeNames(String checkTypeNames) {
		this.checkTypeNames = checkTypeNames;
	}

	public List<PhcPhysicalCheckData> getDatas() {
		return datas;
	}

	public void setDatas(List<PhcPhysicalCheckData> datas) {
		this.datas = datas;
	}

	public Byte getFromType() {
		return fromType;
	}

	public void setFromType(Byte fromType) {
		this.fromType = fromType;
	}

	public Long getFromId() {
		return fromId;
	}

	public void setFromId(Long fromId) {
		this.fromId = fromId;
	}

	public String getStatusName() {
		this.statusName = SimpleStatusEnum.getNameByValue(this.status);
		return statusName;
	}

	public void setStatusName(String statusName) {
		this.statusName = statusName;
	}

    public Boolean getRecheck() {
        return isRecheck;
    }

    public void setRecheck(Boolean recheck) {
        isRecheck = recheck;
    }

    public Byte getSource() {
        return source;
    }

    public void setSource(Byte source) {
        this.source = source;
    }

    public PhcPhysicalCheckThirdInfo getThirdInfo() {
        return thirdInfo;
    }

    public void setThirdInfo(PhcPhysicalCheckThirdInfo thirdInfo) {
        this.thirdInfo = thirdInfo;
    }

    public String getThirdOrgName() {
        return thirdOrgName;
    }

    public void setThirdOrgName(String thirdOrgName) {
        this.thirdOrgName = thirdOrgName;
    }

    public Integer getCheckYear() {
        return checkYear;
    }

    public void setCheckYear(Integer checkYear) {
        this.checkYear = checkYear;
    }

    public List<CheckTypeCount> getCheckTypeCounts() {
        return checkTypeCounts;
    }

    public void setCheckTypeCounts(List<CheckTypeCount> checkTypeCounts) {
        this.checkTypeCounts = checkTypeCounts;
    }

    public Boolean getIsReplenish() {
        return isReplenish;
    }

    public void setIsReplenish(Boolean isReplenish) {
        this.isReplenish = isReplenish;
    }

    public Integer getNotViewNum() {
        return notViewNum;
    }

    public void setNotViewNum(Integer notViewNum) {
        this.notViewNum = notViewNum;
    }

    public Integer getUnconfirmedNum() {
        return unconfirmedNum;
    }

    public void setUnconfirmedNum(Integer unconfirmedNum) {
        this.unconfirmedNum = unconfirmedNum;
    }

    public Integer getSignedNum() {
        return signedNum;
    }

    public void setSignedNum(Integer signedNum) {
        this.signedNum = signedNum;
    }

    public Byte getDataSource() {
        return dataSource;
    }

    public void setDataSource(Byte dataSource) {
        this.dataSource = dataSource;
    }

    public Integer getBodyCheckType() {
        return bodyCheckType;
    }

    public void setBodyCheckType(Integer bodyCheckType) {
        this.bodyCheckType = bodyCheckType;
    }
}