package cn.smarthse.modules.health.entity.work.check;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.health.enums.check.CheckTypeEnum;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "phc_occupational_diseaser_detail")
public class PhcOccupationalDiseaserDetail implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 职业病人id
     */
    @Column(name = "diseaser_id")
    private Long diseaserId;

    /**
     * 体检结果id
     */
    @Column(name = "check_result_id")
    private Long checkResultId;

    /**
     * 体检类型(1上岗 2在岗 3离岗时 4复查 5应急 6离岗后)
     */
    @Column(name = "check_type")
    private Byte checkType;
    
    @Transient
    private String checkTypeName;

    /**
     * 诊断机构id
     */
    @Column(name = "diagnosed_id")
    private Long diagnosedId;

    /**
     * 诊断机构名称
     */
    @Column(name = "diagnosed_name")
    private String diagnosedName;

    /**
     * 诊断开始时间
     */
    @Column(name = "diagnosed_time")
    private Date diagnosedTime;

    /**
     * 诊断结束时间
     */
    @Column(name = "diagnosed_time")
    private Date diagnosedEndTime;

    /**
     * 体检时部门ID
     */
    @Column(name = "check_dept_id")
    private Long checkDeptId;

    /**
     * 体检时部门名称
     */
    @Column(name = "check_dept_name")
    private String checkDeptName;

    /**
     * 体检时岗位idid
     */
    @Column(name = "check_work_id")
    private Long checkWorkId;

    /**
     * 体检时岗位名称
     */
    @Column(name = "check_work_name")
    private String checkWorkName;

    /**
     * 职业病名称
     */
    @Column(name = "disease_name")
    private String diseaseName;

    /**
     * 程度
     */
    private String level;

    /**
     * 相关危害因素id
     */
    @Column(name = "harm_id")
    private Long harmId;

    /**
     * 相关危害因素名称
     */
    @Column(name = "harm_name")
    private String harmName;
    
    /**
     * 接害工龄
     */
    @Column(name = "harm_year")
    private String harmYear;

    /**
     * 诊断鉴定期别
     */
    @Column(name = "issue_num")
    private Integer issueNum;
    
    /**
     * 诊断书id
     */
    @Column(name = "cert_id")
    private Long certId;
    
    /**
     * 诊断书id集合以逗号分隔
     */
    @Column(name = "cert_url")
    private String certUrl;
    
    /**
     * 结果告知id集合以逗号分隔
     */
    @Column(name = "credence_url")
    private String credenceUrl;

    /**
     * 诊断书位置
     */
    @Column(name = "cert_location")
    private String certLocation;

    /**
     * 档案负责人id
     */
    @Column(name = "cert_manager")
    private Long certManager;

    /**
     * 档案负责人名称
     */
    @Column(name = "cert_manager_name")
    private String certManagerName;

    /**
     * 处理措施
     */
    @Column(name = "deal_type_info")
    private String dealTypeInfo;

    /**
     * 是否落实
     */
    @Column(name = "is_sure")
    private Boolean isSure;

    /**
     * 情况说明
     */
    @Column(name = "info_desc")
    private String infoDesc;

    /**
     * 现场处理情况
     */
    @Column(name = "deal_desc")
    private String dealDesc;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 报告出具时间
     */
    @Column(name = "report_issuing_time")
    private Date reportIssuingTime;

    /**
     * 报告状态(1.草稿 2.已上报 3.被退回)
     */
    @Column(name = "report_status")
    private Date reportStatus;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 工作地址所在区域id
     */
    @Column(name = "area_id")
    private Long areaId;

    /**
     * 上报时间
     */
    @Column(name = "report_commit_time")
    private Date reportCommitTime;

    private static final long serialVersionUID = 1L;
    
    @Transient
    private String[] certIds;
    @Transient
    private String[] credenceIds;
    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取职业病人id
     *
     * @return diseaser_id - 职业病人id
     */
    public Long getDiseaserId() {
        return diseaserId;
    }

    /**
     * 设置职业病人id
     *
     * @param diseaserId 职业病人id
     */
    public void setDiseaserId(Long diseaserId) {
        this.diseaserId = diseaserId;
    }

    /**
     * 获取体检结果id
     *
     * @return check_result_id - 体检结果id
     */
    public Long getCheckResultId() {
        return checkResultId;
    }

    /**
     * 设置体检结果id
     *
     * @param checkResultId 体检结果id
     */
    public void setCheckResultId(Long checkResultId) {
        this.checkResultId = checkResultId;
    }

    /**
     * 获取体检类型(1上岗 2在岗 3离岗时 4复查 5应急 6离岗后)
     *
     * @return check_type - 体检类型(1上岗 2在岗 3离岗时 4复查 5应急 6离岗后)
     */
    public Byte getCheckType() {
        return checkType;
    }

    /**
     * 设置体检类型(1上岗 2在岗 3离岗时 4复查 5应急 6离岗后)
     *
     * @param checkType 体检类型(1上岗 2在岗 3离岗时 4复查 5应急 6离岗后)
     */
    public void setCheckType(Byte checkType) {
        this.checkType = checkType;
    }

    /**
     * 获取诊断机构id
     *
     * @return diagnosed_id - 诊断机构id
     */
    public Long getDiagnosedId() {
        return diagnosedId;
    }

    /**
     * 设置诊断机构id
     *
     * @param diagnosedId 诊断机构id
     */
    public void setDiagnosedId(Long diagnosedId) {
        this.diagnosedId = diagnosedId;
    }

    /**
     * 获取诊断机构名称
     *
     * @return diagnosed_name - 诊断机构名称
     */
    public String getDiagnosedName() {
        return diagnosedName;
    }

    /**
     * 设置诊断机构名称
     *
     * @param diagnosedName 诊断机构名称
     */
    public void setDiagnosedName(String diagnosedName) {
        this.diagnosedName = diagnosedName == null ? null : diagnosedName.trim();
    }

    /**
     * 获取诊断时间
     *
     * @return diagnosed_time - 诊断时间
     */
    public Date getDiagnosedTime() {
        return diagnosedTime;
    }

    /**
     * 获取诊断结束时间
     *
     * @return diagnosed_end_time - 诊断结束时间
     */
    public Date getDiagnosedEndTime() {
        return diagnosedEndTime;
    }

    /**
     * 设置诊断时间
     *
     * @param diagnosedTime 诊断时间
     */
    public void setDiagnosedTime(Date diagnosedTime) {
        this.diagnosedTime = diagnosedTime;
    }

    /**
     * 设置诊断时间
     *
     * @param diagnosedTime 诊断时间
     */
    public void setDiagnosedEndTime(Date diagnosedTime) {
        this.diagnosedEndTime = diagnosedEndTime;
    }

    /**
     * 获取体检时部门ID
     *
     * @return check_dept_id - 体检时部门ID
     */
    public Long getCheckDeptId() {
        return checkDeptId;
    }

    /**
     * 设置体检时部门ID
     *
     * @param checkDeptId 体检时部门ID
     */
    public void setCheckDeptId(Long checkDeptId) {
        this.checkDeptId = checkDeptId;
    }

    /**
     * 获取体检时部门名称
     *
     * @return check_dept_name - 体检时部门名称
     */
    public String getCheckDeptName() {
        return checkDeptName;
    }

    /**
     * 设置体检时部门名称
     *
     * @param checkDeptName 体检时部门名称
     */
    public void setCheckDeptName(String checkDeptName) {
        this.checkDeptName = checkDeptName == null ? null : checkDeptName.trim();
    }

    /**
     * 获取体检时岗位idid
     *
     * @return check_work_id - 体检时岗位idid
     */
    public Long getCheckWorkId() {
        return checkWorkId;
    }

    /**
     * 设置体检时岗位idid
     *
     * @param checkWorkId 体检时岗位idid
     */
    public void setCheckWorkId(Long checkWorkId) {
        this.checkWorkId = checkWorkId;
    }

    /**
     * 获取体检时岗位名称
     *
     * @return check_work_name - 体检时岗位名称
     */
    public String getCheckWorkName() {
        return checkWorkName;
    }

    /**
     * 设置体检时岗位名称
     *
     * @param checkWorkName 体检时岗位名称
     */
    public void setCheckWorkName(String checkWorkName) {
        this.checkWorkName = checkWorkName == null ? null : checkWorkName.trim();
    }

    /**
     * 获取职业病名称
     *
     * @return disease_name - 职业病名称
     */
    public String getDiseaseName() {
        return diseaseName;
    }

    /**
     * 设置职业病名称
     *
     * @param diseaseName 职业病名称
     */
    public void setDiseaseName(String diseaseName) {
        this.diseaseName = diseaseName == null ? null : diseaseName.trim();
    }

    /**
     * 获取程度
     *
     * @return level - 程度
     */
    public String getLevel() {
        return level;
    }

    /**
     * 设置程度
     *
     * @param level 程度
     */
    public void setLevel(String level) {
        this.level = level == null ? null : level.trim();
    }

    /**
     * 获取相关危害因素id
     *
     * @return harm_id - 相关危害因素id
     */
    public Long getHarmId() {
        return harmId;
    }

    /**
     * 设置相关危害因素id
     *
     * @param harmId 相关危害因素id
     */
    public void setHarmId(Long harmId) {
        this.harmId = harmId;
    }

    /**
     * 获取相关危害因素名称
     *
     * @return harm_name - 相关危害因素名称
     */
    public String getHarmName() {
        return harmName;
    }

    /**
     * 设置相关危害因素名称
     *
     * @param harmName 相关危害因素名称
     */
    public void setHarmName(String harmName) {
        this.harmName = harmName == null ? null : harmName.trim();
    }

    /**
     * 获取诊断书id
     *
     * @return cert_id - 诊断书id
     */
    public Long getCertId() {
        return certId;
    }

    /**
     * 设置诊断书id
     *
     * @param certId 诊断书id
     */
    public void setCertId(Long certId) {
        this.certId = certId;
    }

    /**
     * 获取诊断书位置
     *
     * @return cert_location - 诊断书位置
     */
    public String getCertLocation() {
        return certLocation;
    }

    /**
     * 设置诊断书位置
     *
     * @param certLocation 诊断书位置
     */
    public void setCertLocation(String certLocation) {
        this.certLocation = certLocation == null ? null : certLocation.trim();
    }

    /**
     * 获取档案负责人id
     *
     * @return cert_manager - 档案负责人id
     */
    public Long getCertManager() {
        return certManager;
    }

    /**
     * 设置档案负责人id
     *
     * @param certManager 档案负责人id
     */
    public void setCertManager(Long certManager) {
        this.certManager = certManager;
    }

    /**
     * 获取档案负责人名称
     *
     * @return cert_manager_name - 档案负责人名称
     */
    public String getCertManagerName() {
        return certManagerName;
    }

    /**
     * 设置档案负责人名称
     *
     * @param certManagerName 档案负责人名称
     */
    public void setCertManagerName(String certManagerName) {
        this.certManagerName = certManagerName == null ? null : certManagerName.trim();
    }

    /**
     * 获取处理措施
     *
     * @return deal_type_info - 处理措施
     */
    public String getDealTypeInfo() {
        return dealTypeInfo;
    }

    /**
     * 设置处理措施
     *
     * @param dealTypeInfo 处理措施
     */
    public void setDealTypeInfo(String dealTypeInfo) {
        this.dealTypeInfo = dealTypeInfo == null ? null : dealTypeInfo.trim();
    }

    /**
     * 获取是否落实
     *
     * @return is_sure - 是否落实
     */
    public Boolean getIsSure() {
        return isSure;
    }

    /**
     * 设置是否落实
     *
     * @param isSure 是否落实
     */
    public void setIsSure(Boolean isSure) {
        this.isSure = isSure;
    }

    /**
     * 获取情况说明
     *
     * @return info_desc - 情况说明
     */
    public String getInfoDesc() {
        return infoDesc;
    }

    /**
     * 设置情况说明
     *
     * @param infoDesc 情况说明
     */
    public void setInfoDesc(String infoDesc) {
        this.infoDesc = infoDesc == null ? null : infoDesc.trim();
    }

    /**
     * 获取现场处理情况
     *
     * @return deal_desc - 现场处理情况
     */
    public String getDealDesc() {
        return dealDesc;
    }

    /**
     * 设置现场处理情况
     *
     * @param dealDesc 现场处理情况
     */
    public void setDealDesc(String dealDesc) {
        this.dealDesc = dealDesc == null ? null : dealDesc.trim();
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public String getCheckTypeName() {
		if(this.checkType!=null){
			checkTypeName = CheckTypeEnum.getName(String.valueOf(this.checkType));
		}
		return checkTypeName;
	}

	public void setCheckTypeName(String checkTypeName) {
		this.checkTypeName = checkTypeName;
	}

	public String getHarmYear() {
		return harmYear;
	}

	public void setHarmYear(String harmYear) {
		this.harmYear = harmYear;
	}

	public String getCertUrl() {
		return certUrl;
	}

	public void setCertUrl(String certUrl) {
		this.certUrl = certUrl;
	}

	public String getCredenceUrl() {
		return credenceUrl;
	}

	public void setCredenceUrl(String credenceUrl) {
		this.credenceUrl = credenceUrl;
	}

	public String[] getCertIds() {
		if(StringUtils.isNotEmpty(this.certUrl)){
			certIds = this.certUrl.split(",");
		}
		return certIds;
	}

	public void setCertIds(String[] certIds) {
		this.certIds = certIds;
		setCertUrl(StringUtils.convertArrayToString(certIds,","));
	}
	public String[] getCredenceIds() {
		if(StringUtils.isNotEmpty(this.credenceUrl)){
			credenceIds = this.credenceUrl.split(",");
		}
		return credenceIds;
	}

	public void setCredenceIds(String[] credenceIds) {
		this.credenceIds = credenceIds;
		setCredenceUrl(StringUtils.convertArrayToString(credenceIds,","));
	}

	public Date getReportIssuingTime() {
		return reportIssuingTime;
	}

	public void setReportIssuingTime(Date reportIssuingTime) {
		this.reportIssuingTime = reportIssuingTime;
	}

	public Date getReportStatus() {
		return reportStatus;
	}

	public void setReportStatus(Date reportStatus) {
		this.reportStatus = reportStatus;
	}

	public Date getReportCommitTime() {
		return reportCommitTime;
	}

	public void setReportCommitTime(Date reportCommitTime) {
		this.reportCommitTime = reportCommitTime;
	}

    public Long getAreaId() {
        return areaId;
    }

    public void setAreaId(Long areaId) {
        this.areaId = areaId;
    }

    public Integer getIssueNum() {
        return issueNum;
    }

    public void setIssueNum(Integer issueNum) {
        this.issueNum = issueNum;
    }
}