package cn.smarthse.modules.health.entity.work.check;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

@Table(name = "phc_occupational_diseaser")
public class PhcOccupationalDiseaser implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 人员信息ID
     */
    @Column(name = "staff_id")
    private Long staffId;

    /**
     * 员工体检时姓名
     */
    @Column(name = "staff_name")
    private String staffName;

    /**
     * 员工体编号
     */
    @Column(name = "staff_work_no")
    private String staffWorkNo;

    /**
     * 员工性别
     */
    @Transient
    private String staffGender;


    /**
     * 监管端状态（0：未处理，1：企业端已上报（企业整改上报时改为该状态），2：已忽略，3：已确认
     */
    @Column(name = "supervise_status")
    private Integer superviseStatus;

    /**
     * 员工生日
     */
    @Transient
    private Date staffBirthday;



    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;




    private static final long serialVersionUID = 1L;
    
    @Transient
    private List<PhcOccupationalDiseaserDetail> details;
    @Transient
    private String feedBackContent;
    /**
     * 创建人对应的部门
     */
    @Column(name = "org_id")
    private Long orgId;

    public String getFeedBackContent() {
        return feedBackContent;
    }

    public void setFeedBackContent(String feedBackContent) {
        this.feedBackContent = feedBackContent;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取人员信息ID
     *
     * @return staff_id - 人员信息ID
     */
    public Long getStaffId() {
        return staffId;
    }

    /**
     * 设置人员信息ID
     *
     * @param staffId 人员信息ID
     */
    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    /**
     * 获取员工体检时姓名
     *
     * @return staff_name - 员工体检时姓名
     */
    public String getStaffName() {
        return staffName;
    }

    /**
     * 设置员工体检时姓名
     *
     * @param staffName 员工体检时姓名
     */
    public void setStaffName(String staffName) {
        this.staffName = staffName == null ? null : staffName.trim();
    }

    /**
     * 获取员工体编号
     *
     * @return staff_work_no - 员工体编号
     */
    public String getStaffWorkNo() {
        return staffWorkNo;
    }

    /**
     * 设置员工体编号
     *
     * @param staffWorkNo 员工体编号
     */
    public void setStaffWorkNo(String staffWorkNo) {
        this.staffWorkNo = staffWorkNo == null ? null : staffWorkNo.trim();
    }

    /**
     * 获取员工性别
     *
     * @return staff_gender - 员工性别
     */
    public String getStaffGender() {
        return staffGender;
    }

    /**
     * 设置员工性别
     *
     * @param staffGender 员工性别
     */
    public void setStaffGender(String staffGender) {
        this.staffGender = staffGender == null ? null : staffGender.trim();
    }

    /**
     * 获取员工生日
     *
     * @return staff_birthday - 员工生日
     */
    public Date getStaffBirthday() {
        return staffBirthday;
    }

    /**
     * 设置员工生日
     *
     * @param staffBirthday 员工生日
     */
    public void setStaffBirthday(Date staffBirthday) {
        this.staffBirthday = staffBirthday;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

	public List<PhcOccupationalDiseaserDetail> getDetails() {
		return details;
	}

	public void setDetails(List<PhcOccupationalDiseaserDetail> details) {
		this.details = details;
	}

    public Integer getSuperviseStatus() {
        return superviseStatus;
    }

    public void setSuperviseStatus(Integer superviseStatus) {
        this.superviseStatus = superviseStatus;
    }
}