package cn.smarthse.modules.health.entity.work.check;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import cn.smarthse.common.framework.Constants;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.modules.datacentre.model.system.SysFileModel;

@Table(name = "phc_diseaser_report")
public class PhcDiseaserReport implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 体检ID
     */
    @Column(name = "check_id")
    private Long checkId;  
    
    /**
     * 体检名称
     */
    @Column(name = "check_name")
    private String checkName;
    
    /**
     * 体检开始时间
     */
    @Column(name = "check_begin_time")
    private Date checkBeginTime;
    
    /**
     * 体检结束时间
     */
    @Column(name = "check_end_time")
    private Date checkEndTime;
    
    /**
     * 疑似职业病人数
     */
    @Column(name = "suspected_count")
    private Integer suspectedCount;
    
    /**
     * 待诊断职业病人数
     */
    @Column(name = "unsure_count")
    private Integer unsureCount;
    
    /**
     * 确诊职业病人数
     */
    @Column(name = "sure_count")
    private Integer sureCount;

    /**
     * 上报时间
     */
    @Column(name = "report_time")
    private Date reportTime;

    /**
     * 报告id
     */
    @Column(name = "report_file_id")
    private Long reportFileId;

    /**
     * 报告url
     */
    @Column(name = "report_file_url")
    private String reportFileUrl;

    /**
     * 报告名称
     */
    @Column(name = "report_file_name")
    private String reportFileName;

    /**
     * 状态（0未完成 1已完成）
     */
    private Byte status;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;    
    
    @Transient
    private String checkDate;
    @Transient
    private String createByName;
    @Transient
    private String[] reportIds;
    @Transient
    private List<SysFileModel> reportFiles;

    /**
     * 可以看到该数据的部门id集合以逗号分隔
     */
    @Column(name = "org_id")
    private String orgId;

    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

   

   

	/**
     * 获取上报时间
     *
     * @return report_time - 上报时间
     */
    public Date getReportTime() {
        return reportTime;
    }

    /**
     * 设置上报时间
     *
     * @param reportTime 上报时间
     */
    public void setReportTime(Date reportTime) {
        this.reportTime = reportTime;
    }

    /**
     * 获取报告id
     *
     * @return report_file_id - 报告id
     */
    public Long getReportFileId() {
        return reportFileId;
    }

    /**
     * 设置报告id
     *
     * @param reportFileId 报告id
     */
    public void setReportFileId(Long reportFileId) {
        this.reportFileId = reportFileId;
    }

    /**
     * 获取报告url
     *
     * @return report_file_url - 报告url
     */
    public String getReportFileUrl() {
        return reportFileUrl;
    }

    /**
     * 设置报告url
     *
     * @param reportFileUrl 报告url
     */
    public void setReportFileUrl(String reportFileUrl) {
        this.reportFileUrl = reportFileUrl == null ? null : reportFileUrl.trim();
    }

    /**
     * 获取报告名称
     *
     * @return report_file_name - 报告名称
     */
    public String getReportFileName() {
        return reportFileName;
    }

    /**
     * 设置报告名称
     *
     * @param reportFileName 报告名称
     */
    public void setReportFileName(String reportFileName) {
        this.reportFileName = reportFileName == null ? null : reportFileName.trim();
    }

    /**
     * 获取状态（0未完成 1已完成）
     *
     * @return status - 状态（0未完成 1已完成）
     */
    public Byte getStatus() {
        return status;
    }

    /**
     * 设置状态（0未完成 1已完成）
     *
     * @param status 状态（0未完成 1已完成）
     */
    public void setStatus(Byte status) {
        this.status = status;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public Integer getSuspectedCount() {
		return suspectedCount;
	}

	public void setSuspectedCount(Integer suspectedCount) {
		this.suspectedCount = suspectedCount;
	}

	public Integer getUnsureCount() {
		return unsureCount;
	}

	public void setUnsureCount(Integer unsureCount) {
		this.unsureCount = unsureCount;
	}

	public Integer getSureCount() {
		return sureCount;
	}

	public void setSureCount(Integer sureCount) {
		this.sureCount = sureCount;
	}

	public String getCheckName() {
		return checkName;
	}

	public void setCheckName(String checkName) {
		this.checkName = checkName;
	}

	public Date getCheckBeginTime() {
		return checkBeginTime;
	}

	public void setCheckBeginTime(Date checkBeginTime) {
		this.checkBeginTime = checkBeginTime;
	}

	public Date getCheckEndTime() {
		return checkEndTime;
	}

	public void setCheckEndTime(Date checkEndTime) {
		this.checkEndTime = checkEndTime;
	}

	public String getCheckDate() {
		if(this.checkBeginTime==null||this.checkEndTime==null) return checkDate;
		String pattern = "yyyy-MM-dd";
		checkDate = DateUtils.format(checkBeginTime, pattern) + Constants.CHECK_TIME_SPLITOR + DateUtils.format(checkEndTime, pattern);
		return checkDate;
	}

	public void setCheckDate(String checkDate) {
		this.checkDate = checkDate;
	}

	public Long getCheckId() {
		return checkId;
	}

	public void setCheckId(Long checkId) {
		this.checkId = checkId;
	}

	public String getCreateByName() {
		return createByName;
	}

	public void setCreateByName(String createByName) {
		this.createByName = createByName;
	}

	public String[] getReportIds() {
		if(StringUtils.isNotEmpty(this.reportFileUrl)){
			reportIds = this.reportFileUrl.split(",");
		}
		return reportIds;
	}

	public void setReportIds(String[] reportIds) {
		this.reportIds = reportIds;
		setReportFileUrl(StringUtils.convertArrayToString(reportIds,","));
	}

	public List<SysFileModel> getReportFiles() {
		return reportFiles;
	}

	public void setReportFiles(List<SysFileModel> reportFiles) {
		this.reportFiles = reportFiles;
	}
	
}