package cn.smarthse.modules.health.entity.work.check;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import cn.smarthse.modules.health.entity.work.check.vo.PhcPhysicalCheckSuspectDiseaseInfo;

@Table(name = "phc_diagnose_disease_process")
public class PhcDiagnoseDiseaseProcess implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;
    
    /**
     * 体检ID
     */
    @Column(name = "check_id")
    private Long checkId;

    /**
     * 人员信息ID
     */
    @Column(name = "staff_id")
    private Long staffId;
    
    /**
     * 人员名称
     */
    @Column(name = "staff_name")
    private String staffName;
    
    /**
     * 人员工号
     */
    @Column(name = "staff_work_no")
    private String staffWorkNo;
    
    /**
     * 人员部门名称
     */
    @Column(name = "staff_dept_name")
    private String staffDeptName;
    
    /**
     * 人员岗位名称
     */
    @Column(name = "staff_work_name")
    private String staffWorkName;
    
    /**
     * 是否完成（0未完成 1已完成）
     */
    @Column(name = "is_finish")
    private Boolean isFinish;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    private static final long serialVersionUID = 1L;  
    
    @Transient
    private List<PhcCheckResultDetail> details;
    
    @Transient
    private PhcPhysicalCheckSuspectDiseaseInfo suspectDiseaseInfo;

    /**
     * 创建人对应的部门
     */
    @Column(name = "org_id")
    private Long orgId;

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }


    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取人员信息ID
     *
     * @return staff_id - 人员信息ID
     */
    public Long getStaffId() {
        return staffId;
    }

    /**
     * 设置人员信息ID
     *
     * @param staffId 人员信息ID
     */
    public void setStaffId(Long staffId) {
        this.staffId = staffId;
    }

    /**
     * 获取是否完成（0未完成 1已完成）
     *
     * @return is_finish - 是否完成（0未完成 1已完成）
     */
    public Boolean getIsFinish() {
        return isFinish;
    }

    /**
     * 设置是否完成（0未完成 1已完成）
     *
     * @param isFinish 是否完成（0未完成 1已完成）
     */
    public void setIsFinish(Boolean isFinish) {
        this.isFinish = isFinish;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

	public Long getCheckId() {
		return checkId;
	}

	public void setCheckId(Long checkId) {
		this.checkId = checkId;
	}

	public String getStaffName() {
		return staffName;
	}

	public void setStaffName(String staffName) {
		this.staffName = staffName;
	}

	public String getStaffWorkNo() {
		return staffWorkNo;
	}

	public void setStaffWorkNo(String staffWorkNo) {
		this.staffWorkNo = staffWorkNo;
	}

	public String getStaffDeptName() {
		return staffDeptName;
	}

	public void setStaffDeptName(String staffDeptName) {
		this.staffDeptName = staffDeptName;
	}

	public String getStaffWorkName() {
		return staffWorkName;
	}

	public void setStaffWorkName(String staffWorkName) {
		this.staffWorkName = staffWorkName;
	}

	public List<PhcCheckResultDetail> getDetails() {
		return details;
	}

	public void setDetails(List<PhcCheckResultDetail> details) {
		this.details = details;
	}

	public PhcPhysicalCheckSuspectDiseaseInfo getSuspectDiseaseInfo() {
		return suspectDiseaseInfo;
	}

	public void setSuspectDiseaseInfo(PhcPhysicalCheckSuspectDiseaseInfo suspectDiseaseInfo) {
		this.suspectDiseaseInfo = suspectDiseaseInfo;
	}
    
}