package cn.smarthse.modules.health.entity.work.check;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import cn.smarthse.common.util.StringUtils;

@Table(name = "phc_check_result_detail")
public class PhcCheckResultDetail implements Serializable {
    /**
     * ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业ID
     */
    private Long cid;

    /**
     * 职业病诊断id
     */
    @Column(name = "diagnose_disease_process")
    private Long diagnoseDiseaseProcess;

    /**
     * 体检结果id
     */
    @Column(name = "check_result_id")
    private Long checkResultId;
    
    /**
     * 疑似职业病名称
     */
    @Column(name = "harm_desc")
    private String harmDesc;

    /**
     * 接害工龄
     */
    @Column(name = "harm_year")
    private String harmYear;

    /**
     * 诊断机构id
     */
    @Column(name = "diagnosed_id")
    private Long diagnosedId;

    /**
     * 诊断机构名称
     */
    @Column(name = "diagnosed_name")
    private String diagnosedName;

    /**
     * 诊断时间
     */
    @Column(name = "diagnosed_time")
    private Date diagnosedTime;

    /**
     * 是否职业病（0否 1是）
     */
    @Column(name = "is_disease")
    private Boolean isDisease;

    /**
     * 职业病名称
     */
    @Column(name = "disease_name")
    private String diseaseName;

    /**
     * 程度
     */
    private String level;

    /**
     * 诊断书id
     */
    @Column(name = "cert_id")
    private Long certId;

    /**
     * 诊断书url
     */
    @Column(name = "cert_url")
    private String certUrl;   

    /**
     * 诊断书名称
     */
    @Column(name = "cert_name")
    private String certName;

    /**
     * 结果告知id
     */
    @Column(name = "credence_id")
    private Long credenceId;

    /**
     * 结果告知url
     */
    @Column(name = "credence_url")
    private String credenceUrl;
    
    /**
     * 结果告知名称
     */
    @Column(name = "credence_name")
    private String credenceName;

    /**
     * 处理措施
     */
    @Column(name = "deal_type_info")
    private String dealTypeInfo;

    /**
     * 是否落实
     */
    @Column(name = "is_sure")
    private Boolean isSure;

    /**
     * 情况说明
     */
    @Column(name = "info_desc")
    private String infoDesc;

    /**
     * 现场处理情况
     */
    @Column(name = "deal_desc")
    private String dealDesc;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    private static final long serialVersionUID = 1L;
        
    @Transient
    private String[] certIds;
    
    @Transient
    private String[] credenceIds;
    @Transient
    private Byte checkDealType;
    /**
     * 获取ID
     *
     * @return id - ID
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置ID
     *
     * @param id ID
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业ID
     *
     * @return cid - 企业ID
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业ID
     *
     * @param cid 企业ID
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取职业病诊断id
     *
     * @return diagnose_disease_process - 职业病诊断id
     */
    public Long getDiagnoseDiseaseProcess() {
        return diagnoseDiseaseProcess;
    }

    /**
     * 设置职业病诊断id
     *
     * @param diagnoseDiseaseProcess 职业病诊断id
     */
    public void setDiagnoseDiseaseProcess(Long diagnoseDiseaseProcess) {
        this.diagnoseDiseaseProcess = diagnoseDiseaseProcess;
    }

    /**
     * 获取体检结果id
     *
     * @return check_result_id - 体检结果id
     */
    public Long getCheckResultId() {
        return checkResultId;
    }

    /**
     * 设置体检结果id
     *
     * @param checkResultId 体检结果id
     */
    public void setCheckResultId(Long checkResultId) {
        this.checkResultId = checkResultId;
    }

    /**
     * 获取接害工龄
     *
     * @return harm_year - 接害工龄
     */
    public String getHarmYear() {
        return harmYear;
    }

    /**
     * 设置接害工龄
     *
     * @param harmYear 接害工龄
     */
    public void setHarmYear(String harmYear) {
        this.harmYear = harmYear == null ? null : harmYear.trim();
    }

    /**
     * 获取诊断机构id
     *
     * @return diagnosed_id - 诊断机构id
     */
    public Long getDiagnosedId() {
        return diagnosedId;
    }

    /**
     * 设置诊断机构id
     *
     * @param diagnosedId 诊断机构id
     */
    public void setDiagnosedId(Long diagnosedId) {
        this.diagnosedId = diagnosedId;
    }

    /**
     * 获取诊断机构名称
     *
     * @return diagnosed_name - 诊断机构名称
     */
    public String getDiagnosedName() {
        return diagnosedName;
    }

    /**
     * 设置诊断机构名称
     *
     * @param diagnosedName 诊断机构名称
     */
    public void setDiagnosedName(String diagnosedName) {
        this.diagnosedName = diagnosedName == null ? null : diagnosedName.trim();
    }

    /**
     * 获取诊断时间
     *
     * @return diagnosed_time - 诊断时间
     */
    public Date getDiagnosedTime() {
        return diagnosedTime;
    }

    /**
     * 设置诊断时间
     *
     * @param diagnosedTime 诊断时间
     */
    public void setDiagnosedTime(Date diagnosedTime) {
        this.diagnosedTime = diagnosedTime;
    }

    /**
     * 获取是否职业病（0否 1是）
     *
     * @return is_disease - 是否职业病（0否 1是）
     */
    public Boolean getIsDisease() {
        return isDisease;
    }

    /**
     * 设置是否职业病（0否 1是）
     *
     * @param isDisease 是否职业病（0否 1是）
     */
    public void setIsDisease(Boolean isDisease) {
        this.isDisease = isDisease;
    }

    /**
     * 获取职业病名称
     *
     * @return disease_name - 职业病名称
     */
    public String getDiseaseName() {
        return diseaseName;
    }

    /**
     * 设置职业病名称
     *
     * @param diseaseName 职业病名称
     */
    public void setDiseaseName(String diseaseName) {
        this.diseaseName = diseaseName == null ? null : diseaseName.trim();
    }

    /**
     * 获取程度
     *
     * @return level - 程度
     */
    public String getLevel() {
        return level;
    }

    /**
     * 设置程度
     *
     * @param level 程度
     */
    public void setLevel(String level) {
        this.level = level == null ? null : level.trim();
    }

    /**
     * 获取诊断书id
     *
     * @return cert_id - 诊断书id
     */
    public Long getCertId() {
        return certId;
    }

    /**
     * 设置诊断书id
     *
     * @param certId 诊断书id
     */
    public void setCertId(Long certId) {
        this.certId = certId;
    }

    /**
     * 获取诊断书url
     *
     * @return cert_url - 诊断书url
     */
    public String getCertUrl() {
        return certUrl;
    }

    /**
     * 设置诊断书url
     *
     * @param certUrl 诊断书url
     */
    public void setCertUrl(String certUrl) {
        this.certUrl = certUrl == null ? null : certUrl.trim();
    }

    /**
     * 获取诊断书名称
     *
     * @return cert_name - 诊断书名称
     */
    public String getCertName() {
        return certName;
    }

    /**
     * 设置诊断书名称
     *
     * @param certName 诊断书名称
     */
    public void setCertName(String certName) {
        this.certName = certName == null ? null : certName.trim();
    }

    /**
     * 获取结果告知id
     *
     * @return credence_id - 结果告知id
     */
    public Long getCredenceId() {
        return credenceId;
    }

    /**
     * 设置结果告知id
     *
     * @param credenceId 结果告知id
     */
    public void setCredenceId(Long credenceId) {
        this.credenceId = credenceId;
    }

    /**
     * 获取结果告知url
     *
     * @return credence_url - 结果告知url
     */
    public String getCredenceUrl() {
        return credenceUrl;
    }

    /**
     * 设置结果告知url
     *
     * @param credenceUrl 结果告知url
     */
    public void setCredenceUrl(String credenceUrl) {
        this.credenceUrl = credenceUrl == null ? null : credenceUrl.trim();
    }

    /**
     * 获取结果告知名称
     *
     * @return credence_name - 结果告知名称
     */
    public String getCredenceName() {
        return credenceName;
    }

    /**
     * 设置结果告知名称
     *
     * @param credenceName 结果告知名称
     */
    public void setCredenceName(String credenceName) {
        this.credenceName = credenceName == null ? null : credenceName.trim();
    }

    /**
     * 获取处理措施
     *
     * @return deal_type_info - 处理措施
     */
    public String getDealTypeInfo() {
        return dealTypeInfo;
    }

    /**
     * 设置处理措施
     *
     * @param dealTypeInfo 处理措施
     */
    public void setDealTypeInfo(String dealTypeInfo) {
        this.dealTypeInfo = dealTypeInfo == null ? null : dealTypeInfo.trim();
    }

    /**
     * 获取是否落实
     *
     * @return is_sure - 是否落实
     */
    public Boolean getIsSure() {
        return isSure;
    }

    /**
     * 设置是否落实
     *
     * @param isSure 是否落实
     */
    public void setIsSure(Boolean isSure) {
        this.isSure = isSure;
    }

    /**
     * 获取情况说明
     *
     * @return info_desc - 情况说明
     */
    public String getInfoDesc() {
        return infoDesc;
    }

    /**
     * 设置情况说明
     *
     * @param infoDesc 情况说明
     */
    public void setInfoDesc(String infoDesc) {
        this.infoDesc = infoDesc == null ? null : infoDesc.trim();
    }

    /**
     * 获取现场处理情况
     *
     * @return deal_desc - 现场处理情况
     */
    public String getDealDesc() {
        return dealDesc;
    }

    /**
     * 设置现场处理情况
     *
     * @param dealDesc 现场处理情况
     */
    public void setDealDesc(String dealDesc) {
        this.dealDesc = dealDesc == null ? null : dealDesc.trim();
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

	public String getHarmDesc() {
		return harmDesc;
	}

	public void setHarmDesc(String harmDesc) {
		this.harmDesc = harmDesc;
	}

	public String[] getCertIds() {
		if(StringUtils.isNotEmpty(this.certUrl)){
			certIds = this.certUrl.split(",");
		}
		return certIds;
	}

	public void setCertIds(String[] certIds) {
		this.certIds = certIds;
		setCertUrl(StringUtils.convertArrayToString(certIds,","));
	}

	public String[] getCredenceIds() {
		if(StringUtils.isNotEmpty(this.credenceUrl)){
			credenceIds = this.credenceUrl.split(",");
		}
		return credenceIds;
	}

	public void setCredenceIds(String[] credenceIds) {
		this.credenceIds = credenceIds;
		setCredenceUrl(StringUtils.convertArrayToString(credenceIds,","));
	}

    public Byte getCheckDealType() {
        return checkDealType;
    }

    public void setCheckDealType(Byte checkDealType) {
        this.checkDealType = checkDealType;
    }
}