package cn.smarthse.modules.health.entity.work.certificate;

import cn.smarthse.common.util.sensitive.SensitiveInfo;
import cn.smarthse.common.util.sensitive.SensitiveType;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Table(name = "certificate_staff_detail")
public @Data
class CertificateStaffDetail implements Serializable {
    @Id
    @Column(name = "id")
//    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业编号
     */
    private Long cid;

    /**
     * 证书id
     */
    @Column(name = "cert_id")
    private Long certId;

    /**
     * 证书编号
     */
    @Column(name = "cert_no")
    @SensitiveInfo(type = SensitiveType.CERTNO)
    private String certNo;

    /**
     * 取证人员id
     */
    @Column(name = "staff_id")
    private Long staffId;

    /**
     * 取证人员姓名
     */
    @SensitiveInfo(type = SensitiveType.USER_NAME)
    @Column(name = "staff_name")
    private String staffName;
    /**
     * 工号
     */
    @Column(name = "work_no")
    private String workNo;


    /**
     * 人员类别
     */
    @Column(name = "staff_type")
    private Integer staffType;

    /**
     * 作业种类（大类）
     */
    @Column(name = "work_type")
    private Integer workType;

    /**
     * 作业种类（小类，详情类）
     */
    @Column(name = "work_type_detail")
    private Integer workTypeDetail;
    /**
     * 初领日期
     */
    @Column(name = "collection_date")
    private Date collectionDate;

    /**
     * 取证日期
     */
    @Column(name = "cert_create_date")
    private Date certCreateDate;

    /**
     * 有效期至
     */
    @Column(name = "validity_date")
    private Date validityDate;

    /**
     * 复审日期
     */
    @Column(name = "repeat_data")
    private Date repeatData;
    /**
     * 发证机关
     */
    @Column(name = "issuing_authority")
    private String issuingAuthority;
    /**
     * 复审/延期提醒：1到期前15天，2到期前30天，3到期前60天，4到期前90天
     */
    @Column(name = "repeat_note")
    private Byte repeatNote;

    /**
     * 提醒时间（天）
     */
    @Column(name = "inform_period")
    private Integer informPeriod;

    /**
     * (即将）到期处理（1.编辑，2忽略）
     */
    @Column(name = "expire_deal")
    private Byte expireDeal;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;

    /**
     * 培训项目上报表train_proj_report的id 或 线下培训项目档案id
     */
    @Column(name = "report_id")
    private Long reportId;

    /**
     * 数据来源， 1企业端， 2机构端
     */
    @Column(name = "data_source")
    private Byte dataSource;

    /**
     * 审核状态 ApprovalStatusEnum
     */
    @Column(name = "status")
    private Byte status;

    /**
     *专兼职
     */
    @Column(name = "full_part")
    private Integer fullPart;

    /**
     * 职务
     */
    private String job;

    /**
     * 万达仓sourceId、数据来源id
     */
    private String sourceId;

    /**
     * 附件
     */
    @Transient
    private List<CertificateFiles> files;

    /**
     * 距复审日期/有效期天数
     */
    @Transient
    private String effectiveDays;

    @Transient
    private List<CertificateStaffDetail> staffs;

    @Transient
    private String certName;

    @Transient
    private Long certNameId;
    /**
     * 人员类别名称，作业种类名称
     */
    @Transient
    private String staffTypeName;
    /**
     * 作业种类名称
     */
    @Transient
    private String workTypeName;
    /**
     * 附件名
     */
    @Transient
    private String filesName;
    /**
     * 小分类列表
     */
    @Transient
    private List<Map<String,Object>> detailList;
    /**
     * 企业所在区域
     */
    @Transient
    private Long areaId;

    /**
     * 企业所在区域级别
     */
    @Transient
    private Byte arealevel;
    /**
     * 性别
     */
    @Transient
    private Byte gender;

    /**
     * id字符串，逗号分隔
     */
    @Transient
    private String detailIds;


    @Transient
    private String workNames;

    @Transient
    private String orgNames;

    @Transient
    private Integer serial;
    @Transient
    private String certDownloadUrl;

    @Transient
    private List<Byte> statusList;
    /**
     * 职能机构人员选择证书列表查询（排除已关联的证书）
     */
    @Transient
    private Boolean chooseCert;
    /**
     * 职能机构人员id
     */
    @Transient
    private Long memberId;
}
