package cn.smarthse.modules.health.entity.work.certificate;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.*;

@Table(name = "certificate_staff")
public class CertificateStaff implements Serializable {
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业编号
     */
    private Long cid;

    /**
     * 证书名称
     */
    private String name;

    /**
     * 名称编号
     */
    @Column(name = "name_id")
    private Long nameId;

    /**
     * 证书原件存放位置
     */
    @Column(name = "storage_location")
    private String storageLocation;

    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;
    
    
    /**
     * 工作场所区域id
     */
    @Column(name = "work_add_area_id")
    private Long workAddAreaId;
    
    
    /**
     * 工作场所详细地址
     */
    @Column(name = "work_add_detail")
    private String workAddDetail;


    /**
     * 组织部门id
     */
    @Column(name = "org_id")
    private String orgId;

    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }
    
    
    
    /**
     * 取证人数
     */
    @Transient
    private Integer staffNum;
    /**
     * 取证人员姓名
     */
    @Transient
    private String staffNames;
    
    /**
     * 序号
     */
    @Transient
    private int serialNum;
    
    /**
     * 取证人员列表
     */
    @Transient
    private List<CertificateStaffDetail> staffs;
    private static final long serialVersionUID = 1L;

    /**
     * @return ID
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业编号
     *
     * @return cid - 企业编号
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业编号
     *
     * @param cid 企业编号
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取证书名称
     *
     * @return name - 证书名称
     */
    public String getName() {
        return name;
    }

    /**
     * 设置证书名称
     *
     * @param name 证书名称
     */
    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    /**
     * 获取名称编号
     *
     * @return name_id - 名称编号
     */
    public Long getNameId() {
        return nameId;
    }

    /**
     * 设置名称编号
     *
     * @param nameId 名称编号
     */
    public void setNameId(Long nameId) {
        this.nameId = nameId;
    }

    /**
     * 获取证书原件存放位置
     *
     * @return storage_location - 证书原件存放位置
     */
    public String getStorageLocation() {
        return storageLocation;
    }

    /**
     * 设置证书原件存放位置
     *
     * @param storageLocation 证书原件存放位置
     */
    public void setStorageLocation(String storageLocation) {
        this.storageLocation = storageLocation == null ? null : storageLocation.trim();
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

	public Integer getStaffNum() {
		return staffNum;
	}

	public void setStaffNum(Integer staffNum) {
		this.staffNum = staffNum;
	}

	public String getStaffNames() {
		return staffNames;
	}

	public void setStaffNames(String staffNames) {
		this.staffNames = staffNames;
	}

	public int getSerialNum() {
		return serialNum;
	}

	public void setSerialNum(int serialNum) {
		this.serialNum = serialNum;
	}

	public List<CertificateStaffDetail> getStaffs() {
		return staffs;
	}

	public void setStaffs(List<CertificateStaffDetail> staffs) {
		this.staffs = staffs;
	}

	public Long getWorkAddAreaId() {
		return workAddAreaId;
	}

	public void setWorkAddAreaId(Long workAddAreaId) {
		this.workAddAreaId = workAddAreaId;
	}

	public String getWorkAddDetail() {
		return workAddDetail;
	}

	public void setWorkAddDetail(String workAddDetail) {
		this.workAddDetail = workAddDetail;
	}

	
    
}