package cn.smarthse.modules.health.entity.work.certificate;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.*;

@Table(name = "certificate_device_detail")
public class CertificateDeviceDetail implements Serializable {
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select RIGHT(uuid_short(), 19)")
    private Long id;

    /**
     * 企业编号
     */
    private Long cid;

    /**
     * 设备证书id
     */
    @Column(name = "cert_id")
    private Long certId;

    /**
     * 证书名称
     */
    private String name;

    /**
     * 名称编号
     */
    @Column(name = "name_id")
    private Long nameId;

    /**
     * 证书编号
     */
    @Column(name = "cert_no")
    private String certNo;

    /**
     * 取证日期
     */
    @Column(name = "cert_create_date")
    private Date certCreateDate;

    /**
     * 有效期至
     */
    @Column(name = "validity_date")
    private Date validityDate;

    /**
     * 复审日期
     */
    @Column(name = "repeat_data")
    private Date repeatData;

    /**
     * 复审/延期提醒：1到期前15天，2到期前30天，3到期前60天，4到期前90天
     */
    @Column(name = "repeat_note")
    private Byte repeatNote;
    
    /**
     * 提醒时间（天）
     */
    @Column(name = "inform_period")
    private Integer informPeriod;
    
    /**
     * (即将）到期处理（1.编辑，2忽略）
     */
    @Column(name = "expire_deal")
    private Byte expireDeal;
    
    /**
     * 是否有效（0-无效，1-有效）
     */
    @Column(name = "is_valid")
    private Boolean isValid;

    /**
     * 创建时间
     */
    @Column(name = "create_date")
    private Date createDate;

    /**
     * 创建人
     */
    @Column(name = "create_by")
    private Long createBy;

    /**
     * 最后修改时间
     */
    @Column(name = "update_date")
    private Date updateDate;

    /**
     * 最后修改人ID
     */
    @Column(name = "update_by")
    private Long updateBy;
    
    /**
     * 附件
     */
    @Transient
    private List<CertificateFiles> files;
    
    /**
     * 距复审日期/有效期天数
     */
    @Transient
    private String effectiveDays;
    /**
     * 设备名称
     */
    @Transient
    private String deviceName;
    /**
     * 设备编号
     */
    @Transient
    private String deviceNo;
    
    private static final long serialVersionUID = 1L;

    /**
     * @return ID
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取企业编号
     *
     * @return cid - 企业编号
     */
    public Long getCid() {
        return cid;
    }

    /**
     * 设置企业编号
     *
     * @param cid 企业编号
     */
    public void setCid(Long cid) {
        this.cid = cid;
    }

    /**
     * 获取设备证书id
     *
     * @return cert_id - 设备证书id
     */
    public Long getCertId() {
        return certId;
    }

    /**
     * 设置设备证书id
     *
     * @param certId 设备证书id
     */
    public void setCertId(Long certId) {
        this.certId = certId;
    }

    /**
     * 获取证书名称
     *
     * @return name - 证书名称
     */
    public String getName() {
        return name;
    }

    /**
     * 设置证书名称
     *
     * @param name 证书名称
     */
    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    /**
     * 获取名称编号
     *
     * @return name_id - 名称编号
     */
    public Long getNameId() {
        return nameId;
    }

    /**
     * 设置名称编号
     *
     * @param nameId 名称编号
     */
    public void setNameId(Long nameId) {
        this.nameId = nameId;
    }

    /**
     * 获取证书编号
     *
     * @return cert_no - 证书编号
     */
    public String getCertNo() {
        return certNo;
    }

    /**
     * 设置证书编号
     *
     * @param certNo 证书编号
     */
    public void setCertNo(String certNo) {
        this.certNo = certNo == null ? null : certNo.trim();
    }

    /**
     * 获取取证日期
     *
     * @return cert_create_date - 取证日期
     */
    public Date getCertCreateDate() {
        return certCreateDate;
    }

    /**
     * 设置取证日期
     *
     * @param certCreateDate 取证日期
     */
    public void setCertCreateDate(Date certCreateDate) {
        this.certCreateDate = certCreateDate;
    }

    /**
     * 获取有效期至
     *
     * @return validity_date - 有效期至
     */
    public Date getValidityDate() {
        return validityDate;
    }

    /**
     * 设置有效期至
     *
     * @param validityDate 有效期至
     */
    public void setValidityDate(Date validityDate) {
        this.validityDate = validityDate;
    }

    /**
     * 获取复审日期
     *
     * @return repeat_data - 复审日期
     */
    public Date getRepeatData() {
        return repeatData;
    }

    /**
     * 设置复审日期
     *
     * @param repeatData 复审日期
     */
    public void setRepeatData(Date repeatData) {
        this.repeatData = repeatData;
    }

    /**
     * 获取复审/延期提醒：1到期前15天，2到期前30天，3到期前60天，4到期前90天
     *
     * @return repeat_note - 复审/延期提醒：1到期前15天，2到期前30天，3到期前60天，4到期前90天
     */
    public Byte getRepeatNote() {
        return repeatNote;
    }

    /**
     * 设置复审/延期提醒：1到期前15天，2到期前30天，3到期前60天，4到期前90天
     *
     * @param repeatNote 复审/延期提醒：1到期前15天，2到期前30天，3到期前60天，4到期前90天
     */
    public void setRepeatNote(Byte repeatNote) {
        this.repeatNote = repeatNote;
    }

    /**
     * 获取是否有效（0-无效，1-有效）
     *
     * @return is_valid - 是否有效（0-无效，1-有效）
     */
    public Boolean getIsValid() {
        return isValid;
    }

    /**
     * 设置是否有效（0-无效，1-有效）
     *
     * @param isValid 是否有效（0-无效，1-有效）
     */
    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    /**
     * 获取创建时间
     *
     * @return create_date - 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置创建时间
     *
     * @param createDate 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取创建人
     *
     * @return create_by - 创建人
     */
    public Long getCreateBy() {
        return createBy;
    }

    /**
     * 设置创建人
     *
     * @param createBy 创建人
     */
    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取最后修改时间
     *
     * @return update_date - 最后修改时间
     */
    public Date getUpdateDate() {
        return updateDate;
    }

    /**
     * 设置最后修改时间
     *
     * @param updateDate 最后修改时间
     */
    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    /**
     * 获取最后修改人ID
     *
     * @return update_by - 最后修改人ID
     */
    public Long getUpdateBy() {
        return updateBy;
    }

    /**
     * 设置最后修改人ID
     *
     * @param updateBy 最后修改人ID
     */
    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

	public List<CertificateFiles> getFiles() {
		return files;
	}

	public void setFiles(List<CertificateFiles> files) {
		this.files = files;
	}

	public Byte getExpireDeal() {
		return expireDeal;
	}

	public void setExpireDeal(Byte expireDeal) {
		this.expireDeal = expireDeal;
	}

	public Integer getInformPeriod() {
		return informPeriod;
	}

	public void setInformPeriod(Integer informPeriod) {
		this.informPeriod = informPeriod;
	}

	public String getEffectiveDays() {
		return effectiveDays;
	}

	public void setEffectiveDays(String effectiveDays) {
		this.effectiveDays = effectiveDays;
	}

	public String getDeviceName() {
		return deviceName;
	}

	public void setDeviceName(String deviceName) {
		this.deviceName = deviceName;
	}

	public String getDeviceNo() {
		return deviceNo;
	}

	public void setDeviceNo(String deviceNo) {
		this.deviceNo = deviceNo;
	}
	
    
}