package cn.smarthse.modules.health.entity.work.assign.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName RiskAssignVO
 * @Description 交办风险查询结果
 * @Author 曾华川
 * @Date 2024年03月11日 11:11
 **/
@Data
public class RiskAssignVO implements Serializable {

    private static final long serialVersionUID = -201841824550511653L;
    private Long id;

    private Long workId;

    /**
     * 企业id
     */
    private Long cid;

    /**
     * 企业名称
     */
    private String companyName;

    /**
     * 统一社会信用代码
     */
    private String unifiedSocialCc;

    /**
     * 行政区划
     */
    private Long areaId;
    private String areaName;

    /**
     * 监督单位
     */
    private Long supervisionUnit;
    private String supervisionUnitName;

    /**
     * 标题
     */
    private String title;

    /**
     * 风险类型（1-低风险，2-高风险）
     */
    private Integer type;

    /**
     * 预警内容
     */
    private String warningContent;

    /**
     * 文件id
     */
    private String fileId;
    private String fileName;

    /**
     * 风险推送状态（0-未推送，1-已推送）
     */
    private Integer pushStatus;

    /**
     * 推送时间（预警时间）
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date pushTime;

    /**
     * 处理时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    private Date dealTime;

    /**
     * 整改状态（1-处理中，2-已完成，3-无需处理）
     */
    private Integer status;

    /**
     * 本次处理部门
     */
    private String dealDeptName;

    /**
     * 本次处理人员
     */
    private String dealWorker;

    /**
     * 处理结果
     */
    private String dealResult;

    /**
     * 推送的企业数
     */
    private Integer pushCompanyCount;

    /**
     * 推送的区县数
     */
    private Integer pushAreaCount;

    /**
     * 1-处理中的数量
     */
    private Integer dealCount;

    /**
     * 2-已完成的数量
     */
    private Integer completeCount;

    /**
     * 3-无需处理的数量
     */
    private Integer noDealCount;

    /**
     * 4-已解除的数量
     */
    private Integer releasedCount;
}
